/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.base.Verify;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.hive.Engine;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestIcebergSparkDropTableCompatibility
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;

    @BeforeTestWithContext
    public void useIceberg() {
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("USE iceberg_test.default", new QueryExecutor.QueryParam[0]);
    }

    @DataProvider
    public static Object[][] tableCleanupEngineConfigurations() {
        return new Object[][]{{Engine.TRINO, Engine.TRINO}, {Engine.TRINO, Engine.SPARK}, {Engine.SPARK, Engine.SPARK}, {Engine.SPARK, Engine.TRINO}};
    }

    @Test(groups={"iceberg", "profile_specific_tests"}, dataProvider="tableCleanupEngineConfigurations")
    public void testCleanupOnDropTable(Engine tableCreatorEngine, Engine tableDropperEngine) {
        String tableName = "test_cleanup_on_drop_table" + TemporaryHiveTable.randomTableSuffix();
        tableCreatorEngine.queryExecutor().executeQuery("CREATE TABLE " + tableName + "(col0 INT, col1 INT)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0]);
        String tableDirectory = this.getTableLocation(tableName);
        this.assertFileExistence(tableDirectory, true, "The table directory exists after creating the table");
        List<String> dataFilePaths = TestIcebergSparkDropTableCompatibility.getDataFilePaths(tableName);
        tableDropperEngine.queryExecutor().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        boolean expectExists = tableDropperEngine == Engine.SPARK;
        this.assertFileExistence(tableDirectory, expectExists, String.format("The table directory %s should be removed after dropping the table", tableDirectory));
        dataFilePaths.forEach(dataFilePath -> this.assertFileExistence((String)dataFilePath, expectExists, String.format("The data file %s removed after dropping the table", dataFilePath)));
    }

    private String getTableLocation(String tableName) {
        Pattern locationPattern = Pattern.compile(".*location = 'hdfs://hadoop-master:9000(.*?)'.*", 32);
        Matcher m = locationPattern.matcher((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + tableName, new QueryExecutor.QueryParam[0]).row(0).get(0));
        if (m.find()) {
            String location = m.group(1);
            Verify.verify((!m.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in SHOW CREATE TABLE result");
    }

    private void assertFileExistence(String path, boolean exists, String description) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.hdfsClient.exist(path)).as(description, new Object[0])).isEqualTo(exists);
    }

    private static List<String> getDataFilePaths(String icebergTableName) {
        List filePaths = QueryExecutors.onTrino().executeQuery(String.format("SELECT file_path FROM \"%s$files\"", icebergTableName), new QueryExecutor.QueryParam[0]).column(1);
        return filePaths.stream().map(TestIcebergSparkDropTableCompatibility::getPath).collect(Collectors.toList());
    }

    private static String getPath(String uri) {
        if (uri.startsWith("hdfs://")) {
            try {
                return new URI(uri).getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid syntax for the URI: " + uri, e);
            }
        }
        return uri;
    }
}

