/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.utils;

import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import java.time.temporal.ChronoUnit;
import java.util.regex.Pattern;
import net.jodah.failsafe.RetryPolicy;
import org.intellij.lang.annotations.Language;

public final class HadoopTestUtils {
    private static final Logger log = Logger.get(HiveProductTest.class);
    public static final String ERROR_COMMITTING_WRITE_TO_HIVE_ISSUE = "https://github.com/trinodb/trino/issues/4936";
    @Language(value="RegExp")
    public static final String ERROR_COMMITTING_WRITE_TO_HIVE_MATCH = "(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)";
    public static final RetryPolicy<QueryResult> ERROR_COMMITTING_WRITE_TO_HIVE_RETRY_POLICY = ((RetryPolicy)new RetryPolicy().handleIf(HadoopTestUtils::isErrorCommittingToHive)).withBackoff(1L, 10L, ChronoUnit.SECONDS).withMaxRetries(30).onRetry(event -> log.warn(event.getLastFailure(), "Query failed on attempt %d, will retry.", new Object[]{event.getAttemptCount()}));

    private HadoopTestUtils() {
    }

    private static boolean isErrorCommittingToHive(Throwable throwable) {
        return Pattern.compile(ERROR_COMMITTING_WRITE_TO_HIVE_MATCH).matcher(Throwables.getStackTraceAsString((Throwable)throwable)).find();
    }
}

