/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Region;

final class S3ClientFactory {
    public static final String AWS_S3_SERVER_TYPE = "aws";
    public static final String MINIO_S3_SERVER_TYPE = "minio";

    S3ClientFactory() {
    }

    public AmazonS3 createS3Client(String serverType) {
        switch (serverType) {
            case "aws": {
                return this.createAwsS3Client();
            }
            case "minio": {
                return this.createMinioS3Client();
            }
        }
        throw new IllegalArgumentException("Invalid value '" + serverType + "' for the s3 server type");
    }

    private AmazonS3 createAwsS3Client() {
        return (AmazonS3)((AmazonS3ClientBuilder)AmazonS3Client.builder().withRegion(Regions.US_EAST_2.getName())).build();
    }

    private AmazonS3 createMinioS3Client() {
        BasicAWSCredentials credentials = new BasicAWSCredentials("minio-access-key", "minio-secret-key");
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        ClientConfiguration clientConfiguration = new ClientConfiguration().withProtocol(Protocol.HTTP).withSignerOverride("AWSS3V4SignerType");
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("http://minio:9080", Region.US_East_2.name()))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider)).build();
    }
}

