/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.Iterables;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeltaLakeAlterTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testAddColumnWithCommentOnTrino() {
        String tableName = "test_dl_add_column_with_comment_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT COMMENT 'new column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "new_col"), (String)"new column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "new_col"), (String)"new column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    public void testAddColumnUnsupportedWriterVersion() {
        String tableName = "test_dl_add_column_unsupported_writer_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='4')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col int", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 4 which is not supported");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    public void testRenameColumn() {
        String tableName = "test_dl_rename_column_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT) USING DELTA LOCATION 's3://%s/%s' TBLPROPERTIES ('delta.columnMapping.mode'='name')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN col TO new_col", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT new_col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT new_col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    public void testRenamePartitionedColumn() {
        String tableName = "test_dl_rename_partitioned_column_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT, part STRING) USING DELTA LOCATION 's3://%s/%s' PARTITIONED BY (part) TBLPROPERTIES ('delta.columnMapping.mode'='name')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'part1')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col, part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN part TO new_part", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2, 'part2')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"}), QueryAssert.Row.row((Object[])new Object[]{2, "part2"})});
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testCommentOnTable() {
        String tableName = "test_dl_comment_table_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment'", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'delta' AND schema_name = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"test comment"})});
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    public void testCommentOnTableUnsupportedWriterVersion() {
        String tableName = "test_dl_comment_table_unsupported_writer_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='4')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 4 which is not supported");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testCommentOnColumn() {
        String tableName = "test_dl_comment_column_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    public void testCommentOnColumnUnsupportedWriterVersion() {
        String tableName = "test_dl_comment_column_unsupported_writer_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='4')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 4 which is not supported");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testTrinoAlterTablePreservesTableMetadata() {
        String tableName = "test_trino_alter_table_preserves_table_metadata_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.appendOnly' = true)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_column INT", new QueryExecutor.QueryParam[0]);
            List properties = (List)Iterables.getOnlyElement((Iterable)QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES " + tableName + "(delta.appendOnly)", new QueryExecutor.QueryParam[0]).rows());
            Assert.assertTrue((boolean)Boolean.parseBoolean((String)properties.get(1)));
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

