/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.S3ClientFactory;
import io.trino.tests.product.hive.Engine;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeDropTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Inject
    @Named(value="s3.server_type")
    private String s3ServerType;
    private AmazonS3 s3;

    @BeforeTestWithContext
    public void setup() {
        super.setUp();
        this.s3 = new S3ClientFactory().createS3Client(this.s3ServerType);
    }

    @DataProvider
    public static Object[][] engineConfigurations() {
        return new Object[][]{{Engine.TRINO, Engine.TRINO, true}, {Engine.TRINO, Engine.TRINO, false}, {Engine.TRINO, Engine.DELTA, true}, {Engine.TRINO, Engine.DELTA, false}, {Engine.DELTA, Engine.TRINO, true}, {Engine.DELTA, Engine.DELTA, true}, {Engine.DELTA, Engine.DELTA, false}};
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"}, dataProvider="engineConfigurations")
    public void testDropTable(Engine creator, Engine dropper, boolean explicitLocation) {
        this.testDropTableAccuracy(creator, dropper, explicitLocation);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testCreateManagedTableInDeltaDropTableInTrino() {
        this.testDropTableAccuracy(Engine.DELTA, Engine.TRINO, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDropTableAccuracy(Engine creator, Engine dropper, boolean explicitLocation) {
        String schemaName = "test_schema_with_location_" + TemporaryHiveTable.randomTableSuffix();
        String schemaLocation = String.format("s3://%s/databricks-compatibility-test-%s", this.bucketName, schemaName);
        String tableName = explicitLocation ? "test_external_table" : "test_managed_table";
        Optional<String> tableLocation = explicitLocation ? Optional.of(String.format("s3://" + this.bucketName + "/databricks-compatibility-test-%s/%s", schemaName, tableName)) : Optional.empty();
        switch (creator) {
            case TRINO: {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA delta.%s WITH (location = '%s')", schemaName, schemaLocation), new QueryExecutor.QueryParam[0]);
                break;
            }
            case DELTA: {
                QueryExecutors.onDelta().executeQuery(String.format("CREATE SCHEMA %s LOCATION \"%s\"", schemaName, schemaLocation), new QueryExecutor.QueryParam[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported engine: " + String.valueOf((Object)creator));
            }
        }
        try {
            QueryExecutors.onTrino().executeQuery("USE delta." + schemaName, new QueryExecutor.QueryParam[0]);
            switch (creator) {
                case TRINO: {
                    QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.%s (a, b) %s AS VALUES (1, 2), (2, 3), (3, 4)", schemaName, tableName, tableLocation.map(location -> "WITH (location = '" + location + "')").orElse("")), new QueryExecutor.QueryParam[0]);
                    break;
                }
                case DELTA: {
                    QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE %s.%s USING DELTA %s AS VALUES (1, 2), (2, 3), (3, 4)", schemaName, tableName, tableLocation.map(location -> "LOCATION \"" + location + "\"").orElse("")), new QueryExecutor.QueryParam[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported engine: " + String.valueOf((Object)creator));
                }
            }
            ObjectListing tableFiles = this.s3.listObjects(this.bucketName, "databricks-compatibility-test-" + schemaName + "/" + tableName);
            Assertions.assertThat((List)tableFiles.getObjectSummaries()).isNotEmpty();
            dropper.queryExecutor().executeQuery("DROP TABLE " + schemaName + "." + tableName, new QueryExecutor.QueryParam[0]);
            tableFiles = this.s3.listObjects(this.bucketName, "databricks-compatibility-test-" + schemaName + "/" + tableName);
            if (explicitLocation) {
                Assertions.assertThat((List)tableFiles.getObjectSummaries()).isNotEmpty();
            } else {
                Assertions.assertThat((List)tableFiles.getObjectSummaries()).isEmpty();
            }
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE IF EXISTS " + schemaName + "." + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        }
    }
}

