/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestHiveAndDeltaLakeCompatibility
extends ProductTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testInformationSchemaColumnsOnPresenceOfHiveView() {
        String schemaName = "test_redirect_to_delta_information_schema_columns_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String hiveViewName = "delta_schema_columns_hive_view_" + TemporaryHiveTable.randomTableSuffix();
        String hiveViewQualifiedName = String.format("hive.%s.%s", schemaName, hiveViewName);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW " + hiveViewQualifiedName + " AS SELECT 1 AS col_one", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_name FROM delta.information_schema.columns WHERE table_schema = '%s'", schemaName), new QueryExecutor.QueryParam[0])).hasNoRows();
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS " + hiveViewQualifiedName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        }
    }
}

