/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableHandle;
import io.trino.tempto.fulfillment.table.TableInstance;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.AllSimpleTypesTableDefinitions;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.testng.annotations.Test;

public class TestAllDatatypesFromHiveConnector
extends HiveProductTest {
    @Requires(value={TextRequirements.class})
    @Test(groups={"smoke"})
    public void testSelectAllDatatypesTextFile() {
        String tableName = AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE.getName();
        this.assertProperAllDatatypesSchema(tableName);
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]);
        this.assertColumnTypes(queryResult);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(123.345f), 234.567, new BigDecimal("346"), new BigDecimal("345.67800"), Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "ala ma    ", true, "kot binarny".getBytes(StandardCharsets.UTF_8)})});
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"jdbc"})
    public void testSelectAllDatatypesOrc() {
        String tableName = TestAllDatatypesFromHiveConnector.mutableTableInstanceOf((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_ORC).getNameInDatabase();
        AllSimpleTypesTableDefinitions.populateDataToHiveTable(tableName);
        this.assertProperAllDatatypesSchema(tableName);
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]);
        this.assertColumnTypes(queryResult);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(123.345f), 234.567, new BigDecimal("346"), new BigDecimal("345.67800"), Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "ala ma    ", true, "kot binarny".getBytes(StandardCharsets.UTF_8)})});
    }

    @Requires(value={RcfileRequirements.class})
    @Test(groups={"jdbc"})
    public void testSelectAllDatatypesRcfile() {
        String tableName = TestAllDatatypesFromHiveConnector.mutableTableInstanceOf((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_RCFILE).getNameInDatabase();
        AllSimpleTypesTableDefinitions.populateDataToHiveTable(tableName);
        this.assertProperAllDatatypesSchema(tableName);
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]);
        this.assertColumnTypes(queryResult);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(123.345f), 234.567, new BigDecimal("346"), new BigDecimal("345.67800"), Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "ala ma    ", true, "kot binarny".getBytes(StandardCharsets.UTF_8)})});
    }

    @Requires(value={AvroRequirements.class})
    @Test(groups={"jdbc"})
    public void testSelectAllDatatypesAvro() {
        String tableName = TestAllDatatypesFromHiveConnector.mutableTableInstanceOf((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_AVRO).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES(2147483647,9223372036854775807,123.345,234.567,346,345.67800,'" + Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)).toString() + "','" + String.valueOf(Date.valueOf("2015-05-10")) + "','ala ma kota','ala ma kot','ala ma    ',true,'kot binarny')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM " + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_float", "real"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", "decimal(10,0)"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"c_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", "varchar(10)"}), QueryAssert.Row.row((Object[])new Object[]{"c_char", "char(10)"}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", "varbinary"})});
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.REAL, JDBCType.DOUBLE, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.TIMESTAMP, JDBCType.DATE, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.CHAR, JDBCType.BOOLEAN, JDBCType.VARBINARY});
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(123.345f), 234.567, new BigDecimal("346"), new BigDecimal("345.67800"), this.isHiveWithBrokenAvroTimestamps() ? Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 18, 0, 35, 123000000)) : Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "ala ma    ", true, "kot binarny".getBytes(StandardCharsets.UTF_8)})});
    }

    private void assertProperAllDatatypesSchema(String tableName) {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM " + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", "tinyint"}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"c_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_float", "real"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", "decimal(10,0)"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"c_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", "varchar(10)"}), QueryAssert.Row.row((Object[])new Object[]{"c_char", "char(10)"}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", "varbinary"})});
    }

    private void assertColumnTypes(QueryResult queryResult) {
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.REAL, JDBCType.DOUBLE, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.TIMESTAMP, JDBCType.DATE, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.CHAR, JDBCType.BOOLEAN, JDBCType.VARBINARY});
    }

    private void assertColumnTypesParquet(QueryResult queryResult) {
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.REAL, JDBCType.DOUBLE, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.TIMESTAMP, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.CHAR, JDBCType.BOOLEAN, JDBCType.VARBINARY});
    }

    @Requires(value={ParquetRequirements.class})
    @Test
    public void testSelectAllDatatypesParquetFile() {
        String tableName = TestAllDatatypesFromHiveConnector.mutableTableInstanceOf((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_PARQUET).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES(127,32767,2147483647,9223372036854775807,123.345,234.567,346,345.67800,'" + Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)).toString() + "','ala ma kota','ala ma kot','ala ma    ',true,'kot binarny')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SHOW COLUMNS FROM %s", tableName), new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", "tinyint"}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"c_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_float", "real"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", "decimal(10,0)"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", "varchar(10)"}), QueryAssert.Row.row((Object[])new Object[]{"c_char", "char(10)"}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", "varbinary"})});
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]);
        this.assertColumnTypesParquet(queryResult);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(123.345f), 234.567, new BigDecimal("346"), new BigDecimal("345.67800"), Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)), "ala ma kota", "ala ma kot", "ala ma    ", true, "kot binarny".getBytes(StandardCharsets.UTF_8)})});
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition) {
        if (tableDefinition.getDatabase().isPresent()) {
            return TestAllDatatypesFromHiveConnector.mutableTableInstanceOf(tableDefinition, (String)tableDefinition.getDatabase().get());
        }
        return TestAllDatatypesFromHiveConnector.mutableTableInstanceOf(TestAllDatatypesFromHiveConnector.tableHandleInSchema(tableDefinition));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition, String database) {
        return TestAllDatatypesFromHiveConnector.mutableTableInstanceOf(TestAllDatatypesFromHiveConnector.tableHandleInSchema(tableDefinition).inDatabase(database));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableHandle tableHandle) {
        return ((MutableTablesState)ThreadLocalTestContextHolder.testContext().getDependency(MutableTablesState.class)).get(tableHandle);
    }

    private static TableHandle tableHandleInSchema(TableDefinition tableDefinition) {
        TableHandle tableHandle = TableHandle.tableHandle((String)tableDefinition.getName());
        if (tableDefinition.getSchema().isPresent()) {
            tableHandle = tableHandle.inSchema((String)tableDefinition.getSchema().get());
        }
        return tableHandle;
    }

    public static final class AvroRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_AVRO).withState(MutableTableRequirement.State.CREATED).build(), TableRequirements.immutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE)});
        }
    }

    public static final class ParquetRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_PARQUET).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcfileRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_RCFILE).withState(MutableTableRequirement.State.CREATED).build(), TableRequirements.immutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE)});
        }
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_ORC).withState(MutableTableRequirement.State.CREATED).build(), TableRequirements.immutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE)});
        }
    }

    public static final class TextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE);
        }
    }
}

