/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.SoftAssertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeWriteDatabricksCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testUpdateCompatibility() {
        String tableName = "test_update_compatibility_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%1$s (a int, b int, c int) USING DELTA LOCATION '%2$s%1$s'", tableName, this.getBaseLocation()), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2, 3), (2, 3, 4), (3, 4, 5), (4, 5, 6), (5, 6, 7)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET b = b * 2 WHERE a % 2 = 1", new QueryExecutor.QueryParam[0]);
            List<TestRow> expectedRows = List.of(TestDeltaLakeWriteDatabricksCompatibility.row(1, 4, 3), TestDeltaLakeWriteDatabricksCompatibility.row(2, 3, 4), TestDeltaLakeWriteDatabricksCompatibility.row(3, 8, 5), TestDeltaLakeWriteDatabricksCompatibility.row(4, 5, 6), TestDeltaLakeWriteDatabricksCompatibility.row(5, 12, 7));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDeleteCompatibility() {
        String tableName = "test_delete_compatibility_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%1$s (a int, b int) USING DELTA LOCATION '%2$s%1$s'", tableName, this.getBaseLocation()), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a % 2 = 0", new QueryExecutor.QueryParam[0]);
            List<QueryAssert.Row> expectedRows = List.of(TestDeltaLakeWriteDatabricksCompatibility.row(1, 2), TestDeltaLakeWriteDatabricksCompatibility.row(3, 4), TestDeltaLakeWriteDatabricksCompatibility.row(5, 6));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDeleteOnPartitionedTableCompatibility() {
        String tableName = "test_delete_on_partitioned_table_compatibility_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%1$s (a int, b int) USING DELTA LOCATION '%2$s%1$s' PARTITIONED BY (b)", tableName, this.getBaseLocation()), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a % 2 = 0", new QueryExecutor.QueryParam[0]);
            List<QueryAssert.Row> expectedRows = List.of(TestDeltaLakeWriteDatabricksCompatibility.row(1, 2), TestDeltaLakeWriteDatabricksCompatibility.row(3, 4), TestDeltaLakeWriteDatabricksCompatibility.row(5, 6));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDeleteOnPartitionKeyCompatibility() {
        String tableName = "test_delete_on_partitioned_table_compatibility_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%1$s (a int, b int) USING DELTA LOCATION '%2$s%1$s' PARTITIONED BY (b)", tableName, this.getBaseLocation()), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE b % 2 = 0", new QueryExecutor.QueryParam[0]);
            List<QueryAssert.Row> expectedRows = List.of(TestDeltaLakeWriteDatabricksCompatibility.row(2, 3), TestDeltaLakeWriteDatabricksCompatibility.row(4, 5));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"}, dataProvider="partition_column_names")
    public void testCaseUpdateInPartition(String partitionColumn) {
        try (CaseTestTable table = new CaseTestTable("update_case_compat", partitionColumn, List.of(TestDeltaLakeWriteDatabricksCompatibility.row(1, 1, 0), TestDeltaLakeWriteDatabricksCompatibility.row(2, 2, 0), TestDeltaLakeWriteDatabricksCompatibility.row(3, 3, 1)));){
            QueryExecutors.onTrino().executeQuery(String.format("UPDATE delta.default.%s SET upper = 0 WHERE lower = 1", table.name()), new QueryExecutor.QueryParam[0]);
            TestDeltaLakeWriteDatabricksCompatibility.assertTable(table, table.rows().map(row -> row.lower() == 1 ? row.withUpper(0) : row));
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"}, dataProvider="partition_column_names")
    public void testCaseUpdatePartitionColumnFails(String partitionColumn) {
        try (CaseTestTable table = new CaseTestTable("update_case_compat", partitionColumn, List.of(TestDeltaLakeWriteDatabricksCompatibility.row(1, 1, 1)));){
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("UPDATE delta.default.%s SET %s = 0 WHERE lower = 1", table.name(), partitionColumn), new QueryExecutor.QueryParam[0])).hasMessageMatching(".*(Updating table partition columns is not supported|The UPDATE SET target column .* doesn't exist)");
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"}, dataProvider="partition_column_names")
    public void testCaseDeletePartialPartition(String partitionColumn) {
        try (CaseTestTable table = new CaseTestTable("delete_case_compat", partitionColumn, List.of(TestDeltaLakeWriteDatabricksCompatibility.row(1, 1, 0), TestDeltaLakeWriteDatabricksCompatibility.row(2, 2, 0), TestDeltaLakeWriteDatabricksCompatibility.row(3, 3, 1)));){
            QueryExecutors.onTrino().executeQuery(String.format("DELETE FROM delta.default.%s WHERE lower = 1", table.name()), new QueryExecutor.QueryParam[0]);
            TestDeltaLakeWriteDatabricksCompatibility.assertTable(table, table.rows().filter(Predicate.not(row -> row.lower() == 1)));
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"}, dataProvider="partition_column_names")
    public void testCaseDeleteEntirePartition(String partitionColumn) {
        try (CaseTestTable table = new CaseTestTable("delete_case_compat", partitionColumn, List.of(TestDeltaLakeWriteDatabricksCompatibility.row(1, 1, 0), TestDeltaLakeWriteDatabricksCompatibility.row(2, 2, 0), TestDeltaLakeWriteDatabricksCompatibility.row(3, 3, 1)));){
            QueryExecutors.onTrino().executeQuery(String.format("DELETE FROM delta.default.%s WHERE %s = 0", table.name(), partitionColumn), new QueryExecutor.QueryParam[0]);
            TestDeltaLakeWriteDatabricksCompatibility.assertTable(table, table.rows().filter(Predicate.not(row -> row.partition() == 0)));
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testTrinoRespectsDatabricksSettingNonNullableColumn() {
        String tableName = "test_databricks_table_with_nonnullable_columns_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%1$s (non_nullable_col INT NOT NULL, nullable_col INT) USING DELTA LOCATION '%2$s%1$s'", tableName, this.getBaseLocation()), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null, 4)", new QueryExecutor.QueryParam[0])).hasMessageContaining("NOT NULL constraint violated for column: non_nullable_col");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (null, 5)", new QueryExecutor.QueryParam[0])).hasMessageContaining("NULL value not allowed for NOT NULL column: non_nullable_col");
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{TestDeltaLakeWriteDatabricksCompatibility.row(1, 2)});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{TestDeltaLakeWriteDatabricksCompatibility.row(1, 2)});
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDatabricksRespectsTrinoSettingNonNullableColumn() {
        String tableName = "test_trino_table_with_nonnullable_columns_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (non_nullable_col INT NOT NULL, nullable_col INT) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null, 4)", new QueryExecutor.QueryParam[0])).hasMessageContaining("NOT NULL constraint violated for column: non_nullable_col");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (null, 5)", new QueryExecutor.QueryParam[0])).hasMessageContaining("NULL value not allowed for NOT NULL column: non_nullable_col");
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{TestDeltaLakeWriteDatabricksCompatibility.row(1, 2)});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{TestDeltaLakeWriteDatabricksCompatibility.row(1, 2)});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-exclude-73", "profile_specific_tests"})
    public void testInsertingIntoDatabricksTableWithAddedNotNullConstraint() {
        String tableName = "test_databricks_table_altered_after_initial_write_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%1$s (non_nullable_col INT, nullable_col INT) USING DELTA LOCATION '%2$s%1$s'", tableName, this.getBaseLocation()), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ALTER COLUMN non_nullable_col SET NOT NULL", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null, 4)", new QueryExecutor.QueryParam[0])).hasMessageContaining("NOT NULL constraint violated for column: non_nullable_col");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (null, 5)", new QueryExecutor.QueryParam[0])).hasMessageContaining("NULL value not allowed for NOT NULL column: non_nullable_col");
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{TestDeltaLakeWriteDatabricksCompatibility.row(1, 2)});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{TestDeltaLakeWriteDatabricksCompatibility.row(1, 2)});
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @DataProvider(name="partition_column_names")
    public static Object[][] partitionColumns() {
        return new Object[][]{{"downpart"}, {"UPPART"}};
    }

    private static QueryAssert.Row row(Integer a, Integer b) {
        return QueryAssert.Row.row((Object[])new Object[]{a, b});
    }

    private static TestRow row(Integer lower, Integer upper, Integer partition) {
        return new TestRow(lower, upper, partition);
    }

    private static void assertTable(CaseTestTable table, Stream<? extends QueryAssert.Row> expectedRows) {
        TestDeltaLakeWriteDatabricksCompatibility.assertTable(table, expectedRows.collect(Collectors.toList()));
    }

    private static void assertTable(CaseTestTable table, List<QueryAssert.Row> expectedRows) {
        SoftAssertions softly = new SoftAssertions();
        softly.check(() -> ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW COLUMNS IN " + table.name(), new QueryExecutor.QueryParam[0])).as("Correct columns after update", new Object[0])).containsOnly(table.columns().stream().map(xva$0 -> QueryAssert.Row.row((Object[])new Object[]{xva$0})).collect(Collectors.toList())));
        softly.check(() -> ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + table.name(), new QueryExecutor.QueryParam[0])).as("Data accessible via Databricks", new Object[0])).containsOnly(expectedRows));
        softly.check(() -> ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + table.name(), new QueryExecutor.QueryParam[0])).as("Data accessible via Trino", new Object[0])).containsOnly(expectedRows));
        softly.assertAll();
    }

    private String getBaseLocation() {
        return "s3://" + this.bucketName + "/databricks-compatibility-test-";
    }

    private static class TestRow
    extends QueryAssert.Row {
        private Integer lower;
        private Integer upper;
        private Integer partition;

        private TestRow(Integer lower, Integer upper, Integer partition) {
            super(List.of(lower, upper, partition));
            this.lower = lower;
            this.upper = upper;
            this.partition = partition;
        }

        public Integer lower() {
            return this.lower;
        }

        public Integer upper() {
            return this.upper;
        }

        public Integer partition() {
            return this.partition;
        }

        public TestRow withLower(Integer newValue) {
            return new TestRow(newValue, this.upper, this.partition);
        }

        public TestRow withUpper(Integer newValue) {
            return new TestRow(this.lower, newValue, this.partition);
        }

        public TestRow withPartition(Integer newValue) {
            return new TestRow(this.lower, this.upper, newValue);
        }

        public String asValues() {
            return String.format("(%s, %s, %s)", this.lower(), this.upper(), this.partition());
        }
    }

    private class CaseTestTable
    implements AutoCloseable {
        private final String name;
        private final List<String> columns;
        private final Collection<TestRow> rows;

        CaseTestTable(String namePrefix, String partitionColumnName, Collection<TestRow> rows) {
            this.name = namePrefix + "_" + TemporaryHiveTable.randomTableSuffix();
            this.columns = List.of("lower", "UPPER", partitionColumnName);
            this.rows = List.copyOf(rows);
            QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%1$s (lower int, UPPER int, %3$s int)\nUSING DELTA\nPARTITIONED BY (%3$s)\nLOCATION '%2$s%1$s'\n", this.name, TestDeltaLakeWriteDatabricksCompatibility.this.getBaseLocation(), partitionColumnName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery(String.format("INSERT INTO default.%s VALUES %s", this.name, rows.stream().map(TestRow::asValues).collect(Collectors.joining(", "))), new QueryExecutor.QueryParam[0]);
        }

        String name() {
            return this.name;
        }

        List<String> columns() {
            return this.columns;
        }

        Stream<TestRow> rows() {
            return this.rows.stream();
        }

        @Override
        public void close() {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + this.name, new QueryExecutor.QueryParam[0]);
        }
    }
}

