/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.fulfillment.table.hive.InlineDataSource;

public final class HiveTableDefinitions {
    private static final String NATION_PARTITIONED_BY_REGIONKEY_TABLE_NAME = "nation_partitioned_by_regionkey";
    public static final int NATION_PARTITIONED_BY_REGIONKEY_NUMBER_OF_LINES_PER_SPLIT = 5;
    public static final HiveTableDefinition NATION_PARTITIONED_BY_BIGINT_REGIONKEY = HiveTableDefinition.builder((String)"nation_partitioned_by_regionkey").setCreateTableDDLTemplate("CREATE %EXTERNAL% TABLE %NAME%(   p_nationkey     BIGINT,   p_name          VARCHAR(25),   p_comment       VARCHAR(152)) PARTITIONED BY (p_regionkey BIGINT)ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ").addPartition("p_regionkey=1", InlineDataSource.createResourceDataSource((String)"nation_partitioned_by_regionkey", (String)HiveTableDefinitions.partitionDataFileResource("bigint", "1"))).addPartition("p_regionkey=2", InlineDataSource.createResourceDataSource((String)"nation_partitioned_by_regionkey", (String)HiveTableDefinitions.partitionDataFileResource("bigint", "2"))).addPartition("p_regionkey=3", InlineDataSource.createResourceDataSource((String)"nation_partitioned_by_regionkey", (String)HiveTableDefinitions.partitionDataFileResource("bigint", "3"))).build();
    public static final HiveTableDefinition NATION_PARTITIONED_BY_VARCHAR_REGIONKEY = HiveTableDefinition.builder((String)"nation_partitioned_by_regionkey").setCreateTableDDLTemplate("CREATE %EXTERNAL% TABLE %NAME%(   p_nationkey     BIGINT,   p_name          VARCHAR(25),   p_comment       VARCHAR(152)) PARTITIONED BY (p_regionkey VARCHAR(20))ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' ").addPartition("p_regionkey='AMERICA'", InlineDataSource.createResourceDataSource((String)"nation_partitioned_by_regionkey", (String)HiveTableDefinitions.partitionDataFileResource("varchar", "america"))).addPartition("p_regionkey='ASIA'", InlineDataSource.createResourceDataSource((String)"nation_partitioned_by_regionkey", (String)HiveTableDefinitions.partitionDataFileResource("varchar", "asia"))).addPartition("p_regionkey='EUROPE'", InlineDataSource.createResourceDataSource((String)"nation_partitioned_by_regionkey", (String)HiveTableDefinitions.partitionDataFileResource("varchar", "europe"))).build();

    private static String partitionDataFileResource(String key, String partition) {
        return String.format("io/trino/tests/product/hive/data/partitioned_nation_%s/nation_region_%s.textfile", key, partition);
    }

    private HiveTableDefinitions() {
    }
}

