/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.inject.name.Named;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import javax.inject.Inject;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestCreateDropSchema
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @BeforeTestWithContext
    public void useIceberg() {
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg"})
    public void testDropSchemaFiles() {
        String schemaName = "schema_without_location_" + TemporaryHiveTable.randomTableSuffix();
        String schemaDir = String.format("%s/%s.db/", this.warehouseDirectory, schemaName);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s", schemaName), new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after creating schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, false, "schema directory exists after dropping schema");
    }

    @Test(groups={"iceberg"})
    public void testDropSchemaFilesWithLocation() {
        String schemaName = "schema_with_empty_location_" + TemporaryHiveTable.randomTableSuffix();
        String schemaDir = this.warehouseDirectory + "/schema-with-empty-location/";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaDir), new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after creating schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, false, "schema directory exists after dropping schema");
    }

    @Test(groups={"iceberg"})
    public void testDropWithExternalFilesInSubdirectory() {
        String schemaName = "schema_with_nonempty_location_" + TemporaryHiveTable.randomTableSuffix();
        String schemaDir = this.warehouseDirectory + "/schema-with-nonempty-location/";
        String subDir = schemaDir + "subdir/";
        String externalFile = subDir + "external-file";
        this.hdfsClient.createDirectory(subDir);
        this.hdfsClient.saveFile(externalFile, "");
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaDir), new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalFile, true, "external file exists after creating schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalFile, true, "external file exists after dropping schema");
        this.hdfsClient.delete(schemaDir);
    }

    @Test(groups={"iceberg"})
    public void testDropWithExternalFiles() {
        String schemaName = "schema_with_files_in_default_location_" + TemporaryHiveTable.randomTableSuffix();
        String schemaDir = String.format("%s/%s.db/", this.warehouseDirectory, schemaName);
        String externalFile = schemaDir + "external-file";
        this.hdfsClient.createDirectory(schemaDir);
        this.hdfsClient.saveFile(externalFile, "");
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after creating schema");
        TestCreateDropSchema.assertQuerySucceeds("DROP SCHEMA " + schemaName);
        this.assertFileExistence(schemaDir, true, "schema directory exists after dropping schema");
        this.assertFileExistence(externalFile, true, "external file exists after dropping schema");
        this.hdfsClient.delete(externalFile);
        this.hdfsClient.delete(schemaDir);
    }

    private void assertFileExistence(String path, boolean exists, String description) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.hdfsClient.exist(path)).as(description, new Object[0])).isEqualTo(exists);
    }

    private static void assertQuerySucceeds(String query) {
        try {
            QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0]);
        }
        catch (QueryExecutionException e) {
            Assertions.fail((String)String.format("Expected query to succeed: %s", query), (Throwable)e.getCause());
        }
    }
}

