/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg.util;

import com.google.common.base.Verify;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcebergTestUtils {
    private IcebergTestUtils() {
    }

    public static String getTableLocation(String tableName) {
        Pattern locationPattern = Pattern.compile(".*location = 'hdfs://hadoop-master:9000(.*?)'.*", 32);
        Matcher m = locationPattern.matcher((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue());
        if (m.find()) {
            String location = m.group(1);
            Verify.verify((!m.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in SHOW CREATE TABLE result");
    }
}

