/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksCompatibilityCleanUp
extends ProductTest {
    private static final Logger log = Logger.get(TestDeltaLakeDatabricksCompatibilityCleanUp.class);
    private static final long SCHEMA_CLEANUP_THRESHOLD = TimeUnit.DAYS.toMillis(7L);
    private static final long MAX_JOB_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final Set<String> SCHEMAS_TO_SKIP = ImmutableSet.of((Object)"information_schema", (Object)"tpch", (Object)"tcpds", (Object)"sf1", (Object)"sf10", (Object)"sf100", (Object[])new String[]{"sf1000", "tpcds_sf1", "tpcds_sf10", "tpcds_sf100", "tpcds_sf1000", "tpcds_sf300"});

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCleanUpOldTablesUsingDelta() {
        long startTime = System.currentTimeMillis();
        List<String> schemas = QueryExecutors.onTrino().executeQuery("SELECT DISTINCT(table_schema) FROM information_schema.tables", new QueryExecutor.QueryParam[0]).rows().stream().map(row -> (String)row.get(0)).filter(schema -> SCHEMAS_TO_SKIP.stream().noneMatch(schema::equalsIgnoreCase)).collect(Collectors.toUnmodifiableList());
        schemas.forEach(schema -> this.cleanSchema((String)schema, startTime));
    }

    private void cleanSchema(String schema, long startTime) {
        List<List<?>> allTables = this.findAllTablesInSchema(schema);
        int numberOfTablesInTheSchema = allTables.size();
        int droppedTablesCount = 0;
        for (List<?> row : allTables) {
            String tableName = (String)row.get(0);
            try {
                List details1 = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE DETAIL %s.%s", schema, tableName), new QueryExecutor.QueryParam[0]).rows();
                long createdAt1 = ((Timestamp)((List)details1.get(0)).get(5)).getTime();
                List details2 = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE DETAIL %s.%s", schema, tableName), new QueryExecutor.QueryParam[0]).rows();
                long createdAt2 = ((Timestamp)((List)details2.get(0)).get(5)).getTime();
                if (createdAt1 != createdAt2 || createdAt1 <= SCHEMA_CLEANUP_THRESHOLD) {
                    QueryExecutors.onDelta().executeQuery(String.format("DROP TABLE IF EXISTS %s.%s", schema, tableName), new QueryExecutor.QueryParam[0]);
                    log.info("Dropped table %s", new Object[]{tableName});
                    ++droppedTablesCount;
                }
                if (System.currentTimeMillis() - startTime <= MAX_JOB_TIME) continue;
                break;
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Exception while dropping table %s", new Object[]{tableName});
            }
        }
        log.debug("Dropped %d tables in schema %s", new Object[]{droppedTablesCount, schema});
        if (droppedTablesCount == numberOfTablesInTheSchema && !schema.equals("default")) {
            try {
                QueryExecutors.onTrino().executeQuery("DROP SCHEMA IF EXISTS " + schema, new QueryExecutor.QueryParam[0]);
                log.info("Dropped schema %s", new Object[]{schema});
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Tried to delete schema %s but failed", new Object[]{schema});
            }
        }
    }

    private List<List<?>> findAllTablesInSchema(String schema) {
        try {
            QueryResult allTables = QueryExecutors.onTrino().executeQuery(String.format("SHOW TABLES IN %s", schema), new QueryExecutor.QueryParam[0]);
            log.debug("Found %d potential tables to drop in schema %s", new Object[]{allTables.rows().size(), schema});
            return allTables.rows();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception while fetching tables for schema %s", new Object[]{schema});
            return ImmutableList.of();
        }
    }
}

