/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksDelete
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDeleteOnAppendOnlyTableFails() {
        String tableName = "test_delete_on_append_only_table_fails_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a INT, b INT)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'          TBLPROPERTIES ('delta.appendOnly' = true)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2, 12)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("This table is configured to only allow appends");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot delete rows from a table with 'delta.appendOnly' set to true");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 12})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }
}

