/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake.util;

import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.util.DatabricksVersion;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Optional;
import org.intellij.lang.annotations.Language;

public final class DeltaLakeTestUtils {
    public static final String DATABRICKS_COMMUNICATION_FAILURE_ISSUE = "https://github.com/trinodb/trino/issues/14391";
    @Language(value="RegExp")
    public static final String DATABRICKS_COMMUNICATION_FAILURE_MATCH = "\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.";

    private DeltaLakeTestUtils() {
    }

    public static Optional<DatabricksVersion> getDatabricksRuntimeVersion() {
        String version = (String)QueryExecutors.onDelta().executeQuery("SELECT java_method('java.lang.System', 'getenv', 'DATABRICKS_RUNTIME_VERSION')", new QueryExecutor.QueryParam[0]).getOnlyValue();
        if (version.equals("null")) {
            return Optional.empty();
        }
        return Optional.of(DatabricksVersion.parse(version));
    }

    public static String getColumnCommentOnTrino(String schemaName, String tableName, String columnName) {
        return (String)QueryExecutors.onTrino().executeQuery("SELECT comment FROM information_schema.columns WHERE table_schema = '" + schemaName + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'", new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    public static String getColumnCommentOnDelta(String schemaName, String tableName, String columnName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE %s.%s %s", schemaName, tableName, columnName), new QueryExecutor.QueryParam[0]);
        return (String)result.row(2).get(1);
    }

    public static String getTableCommentOnDelta(String schemaName, String tableName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE EXTENDED %s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
        return (String)result.rows().stream().filter(row -> row.get(0).equals("Comment")).map(row -> row.get(1)).findFirst().orElseThrow();
    }
}

