/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.jdbc.Row;
import io.trino.jdbc.RowField;
import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestReadUniontype
extends HiveProductTest {
    private static final String TABLE_NAME = "test_read_uniontype";
    private static final String TABLE_NAME_SCHEMA_EVOLUTION = "test_read_uniontype_with_schema_evolution";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void cleanup() {
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
    }

    @DataProvider(name="storage_formats")
    public static Object[][] storageFormats() {
        return new String[][]{{"ORC"}, {"AVRO"}};
    }

    @Test(dataProvider="storage_formats", groups={"smoke"})
    public void testReadUniontype(String storageFormat) {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (id INT,foo UNIONTYPE<INT,DOUBLE,ARRAY<STRING>>)STORED AS %s", TABLE_NAME, storageFormat), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 0, create_union(0, CAST(36 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 1, create_union(1, CAST(NULL AS INT), CAST(7.2 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 2, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 3, create_union(1, CAST(NULL AS INT), CAST(10.8 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 4, create_union(0, CAST(144 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 5, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('hello', 'world'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 6, create_union(0, CAST(180 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 7, create_union(1, CAST(NULL AS INT), CAST(21.6 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 8, create_union(0, CAST(252 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)9);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 36, null, null});
                    break;
                }
                case 1: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 7.2, null});
                    break;
                }
                case 2: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("foo", "bar")});
                    break;
                }
                case 3: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 10.8, null});
                    break;
                }
                case 4: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 144, null, null});
                    break;
                }
                case 5: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("hello", "world")});
                    break;
                }
                case 6: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 180, null, null});
                    break;
                }
                case 7: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 21.6, null});
                    break;
                }
                case 8: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 252, null, null});
                }
            }
        }
    }

    @Test(dataProvider="storage_formats", groups={"smoke"})
    public void testUnionTypeSchemaEvolution(String storageFormat) {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (c0 INT,c1 UNIONTYPE<     STRUCT<a:STRING, b:STRING>,      STRUCT<c:STRING>>) PARTITIONED BY (c2 INT) STORED AS %s", TABLE_NAME_SCHEMA_EVOLUTION, storageFormat), new QueryExecutor.QueryParam[0]);
        switch (storageFormat) {
            case "AVRO": {
                this.testAvroSchemaEvolution();
                break;
            }
            case "ORC": {
                this.testORCSchemaEvolution();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported table format.");
            }
        }
    }

    @Test(groups={"smoke"})
    public void testReadOrcUniontypeWithCheckpoint() {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (id INT,foo UNIONTYPE<INT,DOUBLE,ARRAY<STRING>>)STORED AS ORC TBLPROPERTIES (\"orc.row.index.stride\"=\"1000\")", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1100; ++i) {
            builder.append("SELECT 0, create_union(0, CAST(36 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) ");
            if (i >= 1099) continue;
            builder.append("UNION ALL ");
        }
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s " + builder.toString(), TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)1100);
    }

    private void testORCSchemaEvolution() {
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (c2 = 5) SELECT 0, create_union(0, named_struct('a', 'a1', 'b', 'b1'), named_struct('c', 'ignore')) UNION ALL SELECT 1, create_union(1, named_struct('a', 'ignore', 'b', 'ignore'), named_struct('c', 'c1'))", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %S CHANGE COLUMN c1 c1 UNIONTYPE<STRUCT<a:STRING, b:STRING>, STRUCT<c:STRING, d:STRING>>", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT c0, c1 FROM %s", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)2);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    Row rowValueFirst = TestReadUniontype.rowBuilder().addField("a", (Object)"a1").addField("b", (Object)"b1").build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, rowValueFirst, null});
                    break;
                }
                case 1: {
                    Row rowValueSecond = TestReadUniontype.rowBuilder().addField("c", (Object)"c1").addField("d", null).build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, rowValueSecond});
                }
            }
        }
    }

    private void testAvroSchemaEvolution() {
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (c2 = 5) SELECT 0, create_union(0, named_struct('a', 'a1', 'b', 'b1'), named_struct('c', 'ignore')) UNION ALL SELECT 1, create_union(0, named_struct('a', 'a2', 'b', 'b2'), named_struct('c', 'ignore'))", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %S CHANGE COLUMN c1 c1 UNIONTYPE<STRUCT<a:STRING, b:STRING, d:STRING>, STRUCT<c:STRING>>", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT c0, c1 FROM %s", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)2);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    Row rowValueFirst = TestReadUniontype.rowBuilder().addField("a", (Object)"a1").addField("b", (Object)"b1").addField("d", null).build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, rowValueFirst, null});
                    break;
                }
                case 1: {
                    Row rowValueSecond = TestReadUniontype.rowBuilder().addField("a", (Object)"a2").addField("b", (Object)"b2").addField("d", null).build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, rowValueSecond, null});
                }
            }
        }
    }

    private static void assertStructEquals(Object actual, Object[] expected) {
        Assertions.assertThat((Object)actual).isInstanceOf(Row.class);
        Row actualRow = (Row)actual;
        Assert.assertEquals((int)actualRow.getFields().size(), (int)expected.length);
        for (int i = 0; i < actualRow.getFields().size(); ++i) {
            Assert.assertEquals((Object)((RowField)actualRow.getFields().get(i)).getValue(), (Object)expected[i]);
        }
    }

    private static Row.Builder rowBuilder() {
        return Row.builder();
    }
}

