/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeColumnMappingMode
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeNone() {
        String tableName = "test_dl_column_mapping_mode_none" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingMode(String mode) {
        String tableName = "test_dl_column_mapping_mode_name_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>, a_string STRING, part STRING) USING delta  PARTITIONED BY (part) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, array(struct('nested 1')), struct('databricks 1'),'ala', 'part1'), (2, array(struct('nested 2')), struct('databricks 2'), 'kota', 'part2')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "nested 1", "databricks 1", "ala", "part1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "nested 2", "databricks 2", "kota", "part2"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT a_number, array_col[0].array_struct_element, nested.field1, a_string, part FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_number, array_col[1].array_struct_element, nested.field1, a_string, part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_string FROM delta.default." + tableName + " WHERE a_number = 1", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"ala"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_number FROM delta.default." + tableName + " WHERE nested.field1 = 'databricks 1'", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1})));
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN a_number TO new_a_column", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN nested.field1 TO field2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN part TO new_part", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"new_a_column", "integer", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", "array(row(array_struct_element varchar))", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", "row(field2 varchar)", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", "varchar", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"new_part", "varchar", "", ""})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT new_a_column, array_col[0].array_struct_element, nested.field2, a_string, new_part FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT new_a_column, array_col[1].array_struct_element, nested.field2, a_string, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeNameWithNonLowerCaseColumn(String mode) {
        String tableName = "test_dl_column_mapping_mode_name_non_loewr_case_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (`mIxEd_CaSe` INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0), (9)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{0}), (Object)QueryAssert.Row.row((Object[])new Object[]{9}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"mixed_case", null, null, 0.0, null, "0", "9"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeAddColumn(String mode) {
        String tableName = "test_dl_column_mapping_mode_add_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1), (2)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}), (Object)QueryAssert.Row.row((Object[])new Object[]{2}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN another_varchar STRING", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"another_varchar", "varchar", "", ""})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES  (3, 'new column')", new QueryExecutor.QueryParam[0]);
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "new column"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryExecutors.onDelta().executeQuery("REPLACE TABLE default." + tableName + " USING DELTA PARTITIONED BY (another_varchar) AS SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar = 'new column'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3, "new column"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar = 'expect no rows'", new QueryExecutor.QueryParam[0])).hasNoRows();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar <> 'new column'", new QueryExecutor.QueryParam[0])).hasNoRows();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar IS NOT NULL", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3, "new column"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar IS NULL", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, null}), QueryAssert.Row.row((Object[])new Object[]{2, null})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testShowStatsFromJsonForColumnMappingMode(String mode) {
        String tableName = "test_dl_show_stats_json_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1), (2), (null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testShowStatsFromParquetForColumnMappingMode(String mode) {
        String tableName = "test_dl_show_parquet_stats_parquet_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testShowStatsOnPartitionedForColumnMappingMode(String mode) {
        String tableName = "test_dl_show_stats_partitioned_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, part STRING) USING delta  PARTITIONED BY (part)  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0, 'a')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'b')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null, null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"part", null, 2.0, 0.33333333333, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testUnsupportedOperationsColumnMappingModeName(String mode) {
        String tableName = "test_dl_unsupported_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, a_string STRING) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'one'), (2, 'two')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Delta Lake writer version 5 which is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Delta Lake writer version 5 which is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE default." + tableName + " SET a_string = 'test'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Delta Lake writer version 5 which is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE default." + tableName + " EXECUTE OPTIMIZE", new QueryExecutor.QueryParam[0])).hasMessageContaining("Delta Lake writer version 5 which is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN new_col varchar", new QueryExecutor.QueryParam[0])).hasMessageContaining("Delta Lake writer version 5 which is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN a_number TO renamed_column", new QueryExecutor.QueryParam[0])).hasMessageContaining("This connector does not support renaming columns");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE default." + tableName + " DROP COLUMN a_number", new QueryExecutor.QueryParam[0])).hasMessageContaining("This connector does not support dropping columns");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testSpecialCharacterColumnNamesWithColumnMappingMode(String mode) {
        String tableName = "test_dl_special_character_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (`;{}()\\n\\t=` INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{";{}()\\n\\t=", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @DataProvider
    public Object[][] columnMappingDataProvider() {
        return new Object[][]{{"id"}, {"name"}};
    }
}

