/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.plugin.hive.aws.AwsApiCallStats;
import io.trino.plugin.hive.metastore.glue.AwsSdkUtil;
import io.trino.tempto.ProductTest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksCleanUpGlueMetastore
extends ProductTest {
    private static final Logger log = Logger.get(TestDeltaLakeDatabricksCleanUpGlueMetastore.class);
    private static final String TEST_DATABASE_NAME_PREFIX = "test_";

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testCleanupOrphanedDatabases() {
        AWSGlueAsync glueClient = AWSGlueAsyncClientBuilder.defaultClient();
        long creationTimeMillisThreshold = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L);
        List orphanedDatabases = (List)AwsSdkUtil.getPaginatedResults(arg_0 -> ((AWSGlueAsync)glueClient).getDatabases(arg_0), (Object)new GetDatabasesRequest(), GetDatabasesRequest::setNextToken, GetDatabasesResult::getNextToken, (AwsApiCallStats)new AwsApiCallStats()).map(GetDatabasesResult::getDatabaseList).flatMap(Collection::stream).filter(database -> TestDeltaLakeDatabricksCleanUpGlueMetastore.isOrphanedTestDatabase(database, creationTimeMillisThreshold)).map(Database::getName).collect(ImmutableList.toImmutableList());
        if (!orphanedDatabases.isEmpty()) {
            log.info("Found %s %s* databases that look orphaned, removing", new Object[]{orphanedDatabases.size(), TEST_DATABASE_NAME_PREFIX});
            orphanedDatabases.forEach(database -> {
                try {
                    log.info("Deleting %s database", new Object[]{database});
                    glueClient.deleteDatabase(new DeleteDatabaseRequest().withName(database));
                }
                catch (EntityNotFoundException e) {
                    log.info("Database [%s] not found, could be removed by other cleanup process", new Object[]{database});
                }
                catch (RuntimeException e) {
                    log.warn((Throwable)e, "Failed to remove database [%s]", new Object[]{database});
                }
            });
        }
    }

    private static boolean isOrphanedTestDatabase(Database database, long creationTimeMillisThreshold) {
        return database.getName().startsWith(TEST_DATABASE_NAME_PREFIX) && database.getCreateTime().getTime() <= creationTimeMillisThreshold;
    }
}

