/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksPartitioningCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDatabricksCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumn() {
        this.testDatabricksCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testDatabricksCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDatabricksCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (id, col_name)WITH(location = 's3://%s/%s', partitioned_by = ARRAY['col_name'], checkpoint_interval = " + interval + ") AS VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoCanReadFromCtasTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumn() {
        this.testTrinoCanReadFromCtasTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testTrinoCanReadFromCtasTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTrinoCanReadFromCtasTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s USING DELTA OPTIONS (checkpointInterval = " + interval + ") PARTITIONED BY (`col_name`) LOCATION 's3://%s/%s' AS SELECT * FROM (VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')) t(id, col_name)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDatabricksCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumn() {
        this.testDatabricksCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testDatabricksCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDatabricksCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (id INTEGER, col_name VARCHAR) WITH(location = 's3://%s/%s', partitioned_by = ARRAY['col_name'], checkpoint_interval = " + interval + ") ", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO delta.default.%s VALUES(1, 'with-hyphen'), (2, 'with.dot'), (3, 'with:colon'), (4, 'with/slash'), (5, 'with\\\\backslash'), (6, 'with=equal'), (7, 'with?question'), (8, 'with!exclamation'), (9, 'with%%percent'),(10, 'with space')", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoCanReadTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumn() {
        this.testTrinoCanReadTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testTrinoCanReadTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTrinoCanReadTableCreatedByDatabricksWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (id INTEGER, col_name STRING) USING DELTA OPTIONS (checkpointInterval = " + interval + ") PARTITIONED BY (`col_name`) LOCATION 's3://%s/%s'", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery(String.format("INSERT INTO default.%s VALUES(1, 'with-hyphen'), (2, 'with.dot'), (3, 'with:colon'), (4, 'with/slash'), (5, 'with\\\\backslash'), (6, 'with=equal'), (7, 'with?question'), (8, 'with!exclamation'), (9, 'with%%percent'),(10, 'with space')", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDatabricksCanReadFromTableUpdatedByTrino() {
        this.testDatabricksCanReadFromTableUpdatedByTrinoWithCpIntervalSet(1);
        this.testDatabricksCanReadFromTableUpdatedByTrinoWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDatabricksCanReadFromTableUpdatedByTrinoWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{101, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{102, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{103, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{104, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{105, "with\\\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{106, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{107, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{108, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{109, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{110, "with space"}));
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (id, col_name) WITH(location = 's3://%s/%s', partitioned_by = ARRAY['col_name'], checkpoint_interval = " + interval + ") AS VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("UPDATE delta.default.%s SET id = id + 100", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoCanReadFromTableUpdatedByDatabricks() {
        this.testTrinoCanReadFromTableUpdatedByDatabricksWithCpIntervalSet(1);
        this.testTrinoCanReadFromTableUpdatedByDatabricksWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTrinoCanReadFromTableUpdatedByDatabricksWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{101, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{102, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{103, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{104, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{105, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{106, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{107, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{108, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{109, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{110, "with space"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s USING DELTA OPTIONS (checkpointInterval = " + interval + ") PARTITIONED BY (`col_name`) LOCATION 's3://%s/%s' AS SELECT * FROM (VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')) t(id, col_name)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET id = id + 100", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoCanReadFromTablePartitionChangedByDatabricks() {
        String tableName = "test_dl_create_table_partition_changed_by_databricks_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "part"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s USING DELTA PARTITIONED BY (`original_part_col`) LOCATION 's3://%s/%s' AS SELECT 1 AS original_part_col, 'part' AS new_part_col", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
            QueryExecutors.onDelta().executeQuery("REPLACE TABLE default." + tableName + " USING DELTA PARTITIONED BY (new_part_col) AS SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

