/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public abstract class BaseTestAvroSchemaEvolution
extends ProductTest {
    private static final String ORIGINAL_SCHEMA = "file:///docker/presto-product-tests/avro/original_schema.avsc";
    private static final String RENAMED_COLUMN_SCHEMA = "file:///docker/presto-product-tests/avro/rename_column_schema.avsc";
    private static final String REMOVED_COLUMN_SCHEMA = "file:///docker/presto-product-tests/avro/remove_column_schema.avsc";
    private static final String ADDED_COLUMN_SCHEMA = "file:///docker/presto-product-tests/avro/add_column_schema.avsc";
    private static final String CHANGE_COLUMN_TYPE_SCHEMA = "file:///docker/presto-product-tests/avro/change_column_type_schema.avsc";
    private static final String INCOMPATIBLE_TYPE_SCHEMA = "file:///docker/presto-product-tests/avro/incompatible_type_schema.avsc";
    private final String tableWithSchemaUrl;
    private final String tableWithSchemaLiteral;
    private final String columnsInTableStatement;
    private final String selectStarStatement;
    private final List<String> varcharPartitionColumns;

    protected BaseTestAvroSchemaEvolution(String tableName, String ... varcharPartitionColumns) {
        this.tableWithSchemaLiteral = tableName + "_with_schema_literal";
        this.tableWithSchemaUrl = tableName + "_with_schema_url";
        this.columnsInTableStatement = "SHOW COLUMNS IN %s";
        this.selectStarStatement = "SELECT * FROM %s";
        this.varcharPartitionColumns = ImmutableList.copyOf((Object[])varcharPartitionColumns);
    }

    @BeforeTestWithContext
    public void createAndLoadTable() throws IOException {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (  dummy_col VARCHAR" + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", " + this.getPartitionsAsListString(partitionColumns -> partitionColumns + " varchar")) + ")WITH (  format='AVRO',   avro_schema_url='%s'" + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", partitioned_by=ARRAY[" + this.getPartitionsAsListString(partitionColumns -> "'" + partitionColumns + "'") + "]") + ")", this.tableWithSchemaUrl, ORIGINAL_SCHEMA), new QueryExecutor.QueryParam[0]);
        this.insertData(this.tableWithSchemaUrl, 0, "'stringA0'", "0");
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (  dummy_col VARCHAR" + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", " + this.getPartitionsAsListString(partitionColumns -> partitionColumns + " varchar")) + ")WITH (  format='AVRO',   avro_schema_literal='%s'" + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", partitioned_by=ARRAY[" + this.getPartitionsAsListString(partitionColumns -> "'" + partitionColumns + "'") + "]") + ")", this.tableWithSchemaLiteral, BaseTestAvroSchemaEvolution.readSchemaLiteralFromUrl(ORIGINAL_SCHEMA)), new QueryExecutor.QueryParam[0]);
        this.insertData(this.tableWithSchemaLiteral, 0, "'stringA0'", "0");
    }

    @AfterTestWithContext
    public void dropTestTable() {
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"avro"})
    public void testSelectTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT string_col FROM %s", this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"stringA0"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT string_col FROM %s", this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"stringA0"})});
    }

    @Test(groups={"avro"})
    public void testInsertAfterSchemaEvolution() throws IOException {
        this.assertUnmodified();
        this.alterTableSchemaUrl(ADDED_COLUMN_SCHEMA);
        this.alterTableSchemaLiteral(BaseTestAvroSchemaEvolution.readSchemaLiteralFromUrl(ADDED_COLUMN_SCHEMA));
        this.insertData(this.tableWithSchemaUrl, 1, "'stringA1'", "1", "101");
        this.insertData(this.tableWithSchemaLiteral, 1, "'stringA1'", "1", "101");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0, 100), this.createRow(1, "stringA1", 1, 101)});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0, 100), this.createRow(1, "stringA1", 1, 101)});
    }

    @Test(groups={"avro"})
    public void testSchemaEvolutionWithIncompatibleType() throws IOException {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        this.assertUnmodified();
        this.alterTableSchemaUrl(INCOMPATIBLE_TYPE_SCHEMA);
        this.alterTableSchemaLiteral(BaseTestAvroSchemaEvolution.readSchemaLiteralFromUrl(INCOMPATIBLE_TYPE_SCHEMA));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).hasMessageContaining("Found int, expecting string");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).hasMessageContaining("Found int, expecting string");
    }

    @Test(groups={"avro"})
    public void testSchemaEvolutionWithUrl() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaUrl(CHANGE_COLUMN_TYPE_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "bigint", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaUrl(ADDED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_added", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0, 100)});
        this.alterTableSchemaUrl(REMOVED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, 0)});
        this.alterTableSchemaUrl(RENAMED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_renamed", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", null)});
    }

    @Test(groups={"avro"})
    public void testSchemaEvolutionWithLiteral() throws IOException {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaLiteral(BaseTestAvroSchemaEvolution.readSchemaLiteralFromUrl(CHANGE_COLUMN_TYPE_SCHEMA));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "bigint", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaLiteral(BaseTestAvroSchemaEvolution.readSchemaLiteralFromUrl(ADDED_COLUMN_SCHEMA));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_added", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0, 100)});
        this.alterTableSchemaLiteral(BaseTestAvroSchemaEvolution.readSchemaLiteralFromUrl(REMOVED_COLUMN_SCHEMA));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, 0)});
        this.alterTableSchemaLiteral(BaseTestAvroSchemaEvolution.readSchemaLiteralFromUrl(RENAMED_COLUMN_SCHEMA));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_renamed", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", null)});
    }

    @Test(groups={"avro"})
    public void testSchemaWhenUrlIsUnset() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s UNSET TBLPROPERTIES('avro.schema.url')", this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"dummy_col", "varchar", "", ""})));
    }

    @Test(groups={"avro"})
    public void testSchemaWhenLiteralIsUnset() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s UNSET TBLPROPERTIES('avro.schema.literal')", this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"dummy_col", "varchar", "", ""})));
    }

    @Test(groups={"avro"})
    public void testCreateTableLike() {
        String createTableLikeWithSchemaUrl = this.tableWithSchemaUrl + "_avro_like";
        String createTableLikeWithSchemaLiteral = this.tableWithSchemaLiteral + "_avro_like";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (LIKE %s INCLUDING PROPERTIES)", createTableLikeWithSchemaUrl, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (LIKE %s INCLUDING PROPERTIES)", createTableLikeWithSchemaLiteral, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0]);
        this.insertData(createTableLikeWithSchemaUrl, 0, "'stringA0'", "0");
        this.insertData(createTableLikeWithSchemaLiteral, 0, "'stringA0'", "0");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT string_col FROM %s", createTableLikeWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"stringA0"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT string_col FROM %s", createTableLikeWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"stringA0"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + createTableLikeWithSchemaUrl, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + createTableLikeWithSchemaLiteral, new QueryExecutor.QueryParam[0]);
    }

    private void assertUnmodified() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.columnsInTableStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaUrl), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format(this.selectStarStatement, this.tableWithSchemaLiteral), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
    }

    private void alterTableSchemaUrl(String newUrl) {
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s SET TBLPROPERTIES('avro.schema.url'='%s')", this.tableWithSchemaUrl, newUrl), new QueryExecutor.QueryParam[0]);
    }

    private void alterTableSchemaLiteral(String newLiteral) {
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s SET TBLPROPERTIES('avro.schema.literal'='%s')", this.tableWithSchemaLiteral, newLiteral), new QueryExecutor.QueryParam[0]);
    }

    private void insertData(String tableName, int rowNumber, String ... sqlValues) {
        String columnValues = Joiner.on((String)", ").join((Object[])sqlValues) + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", " + this.getPartitionsAsListString(partitionColumn -> "'" + partitionColumn + "_" + rowNumber + "'"));
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (%s)", tableName, columnValues), new QueryExecutor.QueryParam[0]);
    }

    private QueryAssert.Row createRow(int rowNumber, Object ... data) {
        ArrayList<Object> rowData = new ArrayList<Object>(Arrays.asList(data));
        this.varcharPartitionColumns.forEach(partition -> rowData.add(partition + "_" + rowNumber));
        return new QueryAssert.Row(rowData);
    }

    private List<QueryAssert.Row> prepareShowColumnsResultRows(QueryAssert.Row ... rows) {
        ImmutableList.Builder rowsWithPartitionsBuilder = ImmutableList.builder();
        rowsWithPartitionsBuilder.add((Object[])rows);
        this.varcharPartitionColumns.stream().map(partition -> QueryAssert.Row.row((Object[])new Object[]{partition, "varchar", "partition key", ""})).forEach(arg_0 -> ((ImmutableList.Builder)rowsWithPartitionsBuilder).add(arg_0));
        return rowsWithPartitionsBuilder.build();
    }

    private String getPartitionsAsListString(Function<String, String> partitionMapper) {
        return this.varcharPartitionColumns.stream().map(partitionMapper).collect(Collectors.joining(", "));
    }

    private static String readSchemaLiteralFromUrl(String url) throws IOException {
        return Files.readString(Path.of(URI.create(url)));
    }
}

