/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestHiveMaterializedView
extends HiveProductTest {
    private boolean isTestEnabled() {
        return this.getHiveVersionMajor() >= 3;
    }

    @BeforeTestWithContext
    public void setUp() {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_materialized_view_table(x string) STORED AS ORC TBLPROPERTIES('transactional'='true')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO test_materialized_view_table VALUES ('a'), ('a'), ('b')", new QueryExecutor.QueryParam[0]);
    }

    @AfterTestWithContext
    public void tearDown() {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_materialized_view_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testMaterializedView() {
        this.testMaterializedView(false);
    }

    @Test(groups={"storage_formats"})
    public void testPartitionedMaterializedView() {
        this.testMaterializedView(true);
    }

    private void testMaterializedView(boolean partitioned) {
        if (!this.isTestEnabled()) {
            return;
        }
        QueryExecutors.onHive().executeQuery("DROP MATERIALIZED VIEW test_materialized_view_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE MATERIALIZED VIEW test_materialized_view_view " + (partitioned ? "PARTITIONED ON (x) " : "") + "STORED AS ORC AS SELECT x, count(*) c FROM test_materialized_view_table GROUP BY x", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW TABLES", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"test_materialized_view_table"}), QueryAssert.Row.row((Object[])new Object[]{"test_materialized_view_view"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM test_materialized_view_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c", "bigint", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"x", "varchar", partitioned ? "partition key" : "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT x, c FROM test_materialized_view_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", 2}), QueryAssert.Row.row((Object[])new Object[]{"b", 1})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT x, c FROM test_materialized_view_view WHERE x = 'a'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", 2})});
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO test_materialized_view_view(x, c) VALUES ('x', 42)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot write to Hive materialized view");
        QueryExecutors.onHive().executeQuery("DROP MATERIALIZED VIEW test_materialized_view_view", new QueryExecutor.QueryParam[0]);
    }
}

