/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestIcebergProcedureCalls
extends ProductTest {
    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testRollbackToSnapshot() throws InterruptedException {
        String tableName = "test_rollback_to_snapshot_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (a INTEGER)", tableName), new QueryExecutor.QueryParam[0]);
        Thread.sleep(1L);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES 1", tableName), new QueryExecutor.QueryParam[0]);
        Thread.sleep(1L);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES 2", tableName), new QueryExecutor.QueryParam[0]);
        long snapshotId = this.getSecondOldestTableSnapshot(tableName);
        QueryExecutors.onTrino().executeQuery(String.format("call system.rollback_to_snapshot('default', '%s', %d)", tableName, snapshotId), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testRollbackToSnapshotWithNullArgument() {
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.rollback_to_snapshot(NULL, 'customer_orders', 8954597067493422955)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*schema cannot be null.*");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.rollback_to_snapshot('testdb', NULL, 8954597067493422955)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*table cannot be null.*");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.rollback_to_snapshot('testdb', 'customer_orders', NULL)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*snapshot_id cannot be null.*");
    }

    private long getSecondOldestTableSnapshot(String tableName) {
        return (Long)QueryExecutors.onTrino().executeQuery(String.format("SELECT snapshot_id FROM iceberg.default.\"%s$snapshots\" WHERE parent_id IS NOT NULL ORDER BY committed_at FETCH FIRST 1 ROW WITH TIES", tableName), new QueryExecutor.QueryParam[0]).getOnlyValue();
    }
}

