/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergRenameTable
extends ProductTest {
    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testRenameTable() {
        String tableName = "iceberg.default.test_rename_table_" + TestingNames.randomNameSuffix();
        String newName = "iceberg.default.test_rename_table_new_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + "(a bigint, b varchar)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + "(a, b) VALUES (NULL, NULL), (-42, 'abc'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE " + tableName + " RENAME TO " + newName, new QueryExecutor.QueryParam[0]);
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Table '" + tableName + "' does not exist");
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + newName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + newName, new QueryExecutor.QueryParam[0]);
        }
    }
}

