/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.jdbc;

import io.trino.jdbc.TrinoConnection;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.trino.tempto.internal.convention.SqlResultDescriptor;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.TpchTableResults;
import io.trino.tests.product.utils.JdbcDriverUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestJdbc
extends ProductTest {
    private static final String TABLE_NAME = "nation_table_name";

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldExecuteQuery() throws SQLException {
        try (Statement statement = this.connection().createStatement();){
            QueryResult result = this.queryResult(statement, "select * from hive.default.nation");
            QueryAssert.assertThat((QueryResult)result).matches(TpchTableResults.PRESTO_NATION_RESULT);
        }
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableAndMutableNationTable.class})
    public void shouldInsertSelectQuery() throws SQLException {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableNameInDatabase, new QueryExecutor.QueryParam[0])).hasNoRows();
        try (Statement statement = this.connection().createStatement();){
            Assertions.assertThat((int)statement.executeUpdate("insert into " + tableNameInDatabase + " select * from nation")).isEqualTo(25);
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableNameInDatabase, new QueryExecutor.QueryParam[0])).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldExecuteQueryWithSelectedCatalogAndSchema() throws SQLException {
        this.connection().setCatalog("hive");
        this.connection().setSchema("default");
        try (Statement statement = this.connection().createStatement();){
            QueryResult result = this.queryResult(statement, "select * from nation");
            QueryAssert.assertThat((QueryResult)result).matches(TpchTableResults.PRESTO_NATION_RESULT);
        }
    }

    @Test(groups={"jdbc"})
    public void shouldSetTimezone() throws SQLException {
        String timeZoneId = "Indian/Kerguelen";
        ((TrinoConnection)this.connection()).setTimeZoneId(timeZoneId);
        this.assertConnectionTimezone(this.connection(), timeZoneId);
    }

    private void assertConnectionTimezone(Connection connection, String timeZoneId) throws SQLException {
        try (Statement statement = connection.createStatement();){
            QueryResult result = this.queryResult(statement, "select current_timezone()");
            QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{timeZoneId})});
        }
    }

    @Test(groups={"jdbc"})
    public void shouldSetLocale() throws SQLException {
        ((TrinoConnection)this.connection()).setLocale(Locale.CHINESE);
        try (Statement statement = this.connection().createStatement();){
            QueryResult result = this.queryResult(statement, "SELECT date_format(TIMESTAMP '2001-01-09 09:04', '%M')");
            QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"\u4e00\u6708"})});
        }
    }

    @Test(groups={"jdbc"})
    public void shouldGetSchemas() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getSchemas("hive", null));
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", "hive"})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetTables() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getTables("hive", null, null, null));
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "default", "nation", "TABLE", null, null, null, null, null, null})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetColumns() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getColumns("hive", "default", "nation", null));
        QueryAssert.assertThat((QueryResult)result).matches(SqlResultDescriptor.sqlResultDescriptorForResource((String)"io/trino/tests/product/jdbc/get_nation_columns.result"));
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetTableTypes() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getTableTypes());
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"VIEW"})});
    }

    @Test(groups={"jdbc"})
    public void testSessionProperties() throws SQLException {
        String joinDistributionType = "join_distribution_type";
        String defaultValue = "AUTOMATIC";
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), joinDistributionType)).isEqualTo(defaultValue);
        JdbcDriverUtils.setSessionProperty(this.connection(), joinDistributionType, "BROADCAST");
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), joinDistributionType)).isEqualTo("BROADCAST");
        JdbcDriverUtils.resetSessionProperty(this.connection(), joinDistributionType);
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), joinDistributionType)).isEqualTo(defaultValue);
    }

    @Test(groups={"jdbc"})
    public void testDeallocate() throws Exception {
        try (Connection connection = this.connection();){
            for (int i = 0; i < 200; ++i) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT '" + "a".repeat(300) + "'");){
                    preparedStatement.executeQuery().close();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed at " + i, e);
                }
            }
        }
    }

    private QueryResult queryResult(Statement statement, String query) throws SQLException {
        return QueryResult.forResultSet((ResultSet)statement.executeQuery(query));
    }

    private DatabaseMetaData metaData() throws SQLException {
        return this.connection().getMetaData();
    }

    private Connection connection() {
        return QueryExecutors.onTrino().getConnection();
    }

    private static class ImmutableAndMutableNationTable
    implements RequirementsProvider {
        private ImmutableAndMutableNationTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION), TableRequirements.mutableTable((TableDefinition)TpchTableDefinitions.NATION, (String)TestJdbc.TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED)});
        }
    }
}

