/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import io.airlift.units.Duration;
import io.trino.tempto.query.QueryResult;
import java.util.function.Supplier;
import org.testng.Assert;

public final class QueryAssertions {
    public static void assertContainsEventually(Supplier<QueryResult> all, QueryResult expectedSubset, Duration timeout) {
        QueryAssertions.assertEventually(timeout, () -> QueryAssertions.assertContains((QueryResult)all.get(), expectedSubset));
    }

    public static void assertEventually(Duration timeout, Runnable assertion) {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                assertion.run();
                return;
            }
            catch (AssertionError | Exception e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    public static void assertContains(QueryResult all, QueryResult expectedSubset) {
        for (Object row : expectedSubset.rows()) {
            if (all.rows().contains(row)) continue;
            Assert.fail((String)String.format("expected row missing: %s\nAll %s rows:\n    %s\nExpected subset %s rows:\n    %s\n", row, all.getRowsCount(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)all.rows(), (int)100)), expectedSubset.getRowsCount(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSubset.rows(), (int)100))));
        }
    }

    private QueryAssertions() {
    }
}

