/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.JDBCType;
import java.util.List;
import org.testng.annotations.Test;

public class TestSystemConnector
extends ProductTest {
    @Test(groups={"system", "jdbc"})
    public void selectRuntimeNodes() {
        String sql = "SELECT node_id, http_uri, node_version, state FROM system.runtime.nodes";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR}).hasAnyRows();
    }

    @Test(groups={"system", "jdbc"})
    public void testRuleStats() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT rule_name, invocations, matches, failures FROM system.runtime.optimizer_rule_stats", new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT}).hasAnyRows();
    }

    @Test(groups={"system", "jdbc"})
    public void selectRuntimeQueries() {
        String sql = "SELECT  query_id,  state,  user,  query,  resource_group_id,  queued_time_ms,  analysis_time_ms,  planning_time_ms,  created,  started,  last_heartbeat,  \"end\",  error_type,  error_code FROM system.runtime.queries";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.ARRAY, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.VARCHAR, JDBCType.VARCHAR}).hasAnyRows();
    }

    @Test(groups={"system", "jdbc"})
    public void selectRuntimeTasks() {
        String sql = "SELECT  node_id,  task_id,  stage_id,  query_id,  state,  splits,  queued_splits,  running_splits,  completed_splits,  split_scheduled_time_ms,  split_cpu_time_ms,  split_blocked_time_ms,  raw_input_bytes,  raw_input_rows,  processed_input_bytes,  processed_input_rows,  output_bytes,  output_rows,  physical_input_bytes,  physical_written_bytes,  created,  start,  last_heartbeat,  \"end\" FROM SYSTEM.runtime.tasks";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.TIMESTAMP_WITH_TIMEZONE}).hasAnyRows();
    }

    @Test(groups={"system", "jdbc"})
    public void selectMetadataCatalogs() {
        String sql = "select catalog_name, connector_id, connector_name from system.metadata.catalogs";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR}).contains((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"jmx", "jmx", "jmx"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"system", "system", "system"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"tpch", "tpch", "tpch"})));
    }
}

