/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.BaseTestHiveCoercion;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.JDBCType;
import java.util.Locale;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestHiveCoercionOnPartitionedTable
extends BaseTestHiveCoercion {
    public static final HiveTableDefinition HIVE_COERCION_TEXTFILE = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("TEXTFILE", Optional.empty(), Optional.of("DELIMITED FIELDS TERMINATED BY '|'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_PARQUET = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("PARQUET", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_AVRO = TestHiveCoercionOnPartitionedTable.avroTableDefinitionBuilder().setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_ORC = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("ORC", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCTEXT = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("RCFILE", Optional.of("RCTEXT"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCBINARY = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("RCFILE", Optional.of("RCBINARY"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe'")).setNoData().build();

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat, Optional<String> recommendTableName, Optional<String> rowFormat) {
        String tableName = String.format("%s_hive_coercion", recommendTableName.orElse(fileFormat).toLowerCase(Locale.ENGLISH));
        String floatType = fileFormat.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "FLOAT";
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(    row_to_row                 STRUCT<keep: STRING, ti2si: TINYINT, si2int: SMALLINT, int2bi: INT, bi2vc: BIGINT, lower2uppercase: BIGINT>,     list_to_list               ARRAY<STRUCT<ti2int: TINYINT, si2bi: SMALLINT, bi2vc: BIGINT, remove: STRING>>,     map_to_map                 MAP<TINYINT, STRUCT<ti2bi: TINYINT, int2bi: INT, float2double: " + floatType + ">>,     tinyint_to_smallint        TINYINT,    tinyint_to_int             TINYINT,    tinyint_to_bigint          TINYINT,    smallint_to_int            SMALLINT,    smallint_to_bigint         SMALLINT,    int_to_bigint              INT,    bigint_to_varchar          BIGINT,    float_to_double            " + floatType + ",    double_to_float            DOUBLE,    shortdecimal_to_shortdecimal          DECIMAL(10,2),    shortdecimal_to_longdecimal           DECIMAL(10,2),    longdecimal_to_shortdecimal           DECIMAL(20,12),    longdecimal_to_longdecimal            DECIMAL(20,12),    float_to_decimal           " + floatType + ",    double_to_decimal          DOUBLE,    decimal_to_float                   DECIMAL(10,5),    decimal_to_double                  DECIMAL(10,5),    short_decimal_to_varchar           DECIMAL(10,5),    long_decimal_to_varchar            DECIMAL(20,12),    short_decimal_to_bounded_varchar   DECIMAL(10,5),    long_decimal_to_bounded_varchar    DECIMAL(20,12),    varchar_to_bigger_varchar          VARCHAR(3),    varchar_to_smaller_varchar         VARCHAR(3),    char_to_bigger_char                CHAR(3),    char_to_smaller_char               CHAR(3)) PARTITIONED BY (id BIGINT) " + rowFormat.map(s -> String.format("ROW FORMAT %s ", s)).orElse("") + "STORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder avroTableDefinitionBuilder() {
        return HiveTableDefinition.builder((String)"avro_hive_coercion").setCreateTableDDLTemplate("CREATE TABLE %NAME%(    int_to_bigint              INT,    float_to_double            DOUBLE) PARTITIONED BY (id BIGINT) STORED AS AVRO");
    }

    @Requires(value={TextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionTextFile() {
        this.doTestHiveCoercion(HIVE_COERCION_TEXTFILE);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionOrc() {
        this.doTestHiveCoercion(HIVE_COERCION_ORC);
    }

    @Requires(value={RcTextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcText() {
        this.doTestHiveCoercion(HIVE_COERCION_RCTEXT);
    }

    @Requires(value={RcBinaryRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcBinary() {
        this.doTestHiveCoercion(HIVE_COERCION_RCBINARY);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionParquet() {
        this.doTestHiveCoercion(HIVE_COERCION_PARQUET);
    }

    @Requires(value={AvroRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionAvro() {
        String tableName = TestHiveCoercionOnPartitionedTable.mutableTableInstanceOf((TableDefinition)HIVE_COERCION_AVRO).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (id=1) VALUES(2323, 0.5),(-2323, -1.5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM " + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.BIGINT, JDBCType.DOUBLE, JDBCType.BIGINT});
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2323L, 0.5, 1}), QueryAssert.Row.row((Object[])new Object[]{-2323L, -1.5, 1})});
    }

    public static final class AvroRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_AVRO).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class ParquetRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcBinaryRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCBINARY).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcTextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCTEXT).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class TextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_TEXTFILE).withState(MutableTableRequirement.State.CREATED).build();
        }
    }
}

