/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.cassandra;

import io.airlift.units.Duration;
import io.trino.jdbc.Row;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.internal.query.CassandraQueryExecutor;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.TpchTableResults;
import io.trino.tests.product.cassandra.CassandraTpchTableDefinitions;
import io.trino.tests.product.cassandra.DataTypesTableDefinition;
import io.trino.tests.product.utils.QueryAssertions;
import io.trino.tests.product.utils.QueryExecutors;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSelect
extends ProductTest
implements RequirementsProvider {
    private Configuration configuration;

    public Requirement getRequirements(Configuration configuration) {
        this.configuration = configuration;
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_NATION), TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER), TableRequirements.immutableTable((TableDefinition)DataTypesTableDefinition.CASSANDRA_ALL_TYPES)});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectNation() {
        String sql = String.format("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM %s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithEqualityFilterOnPartitioningKey() {
        String sql = String.format("SELECT n_nationkey FROM %s.%s.%s WHERE n_nationkey = 0", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithFilterOnPartitioningKey() {
        String sql = String.format("SELECT n_nationkey FROM %s.%s.%s WHERE n_nationkey > 23", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{24})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithEqualityFilterOnNonPartitioningKey() {
        String sql = String.format("SELECT n_name FROM %s.%s.%s WHERE n_name = 'UNITED STATES'", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"UNITED STATES"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithNonEqualityFilterOnNonPartitioningKey() {
        String sql = String.format("SELECT n_name FROM %s.%s.%s WHERE n_name < 'B'", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ALGERIA"}), QueryAssert.Row.row((Object[])new Object[]{"ARGENTINA"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithMorePartitioningKeysThanLimit() {
        String sql = String.format("SELECT s_suppkey FROM %s.%s.%s WHERE s_suppkey = 10", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithMorePartitioningKeysThanLimitNonPK() {
        String sql = String.format("SELECT s_suppkey FROM %s.%s.%s WHERE s_name = 'Supplier#000000010'", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testAllDataTypes() {
        QueryResult query = QueryExecutors.onTrino().executeQuery(String.format("SELECT a, b, bl, bo, d, do, dt, f, fr, i, integer, l, m, s, si, t, ti, ts, tu, u, v, vari FROM %s.%s.%s", "cassandra", "test", DataTypesTableDefinition.CASSANDRA_ALL_TYPES.getName()), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)query).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.BIGINT, JDBCType.VARBINARY, JDBCType.BOOLEAN, JDBCType.DOUBLE, JDBCType.DOUBLE, JDBCType.DATE, JDBCType.REAL, JDBCType.VARCHAR, JDBCType.JAVA_OBJECT, JDBCType.INTEGER, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.SMALLINT, JDBCType.VARCHAR, JDBCType.TINYINT, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.JAVA_OBJECT, JDBCType.JAVA_OBJECT, JDBCType.VARCHAR, JDBCType.VARCHAR}).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"\u0000", Long.MIN_VALUE, new byte[]{0}, false, Float.valueOf(0.0f), Double.MIN_VALUE, Date.valueOf("1970-01-02"), Float.valueOf(Float.MIN_VALUE), "[0]", "0.0.0.0", Integer.MIN_VALUE, "[0]", "{\"\\u0000\":-2147483648,\"a\":0}", "[0]", (short)Short.MIN_VALUE, "\u0000", (byte)-128, Timestamp.from(OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()), "d2177dd0-eaa2-11de-a572-001b779c76e3", "01234567-0123-0123-0123-0123456789ab", "\u0000", String.valueOf(Long.MIN_VALUE)}), QueryAssert.Row.row((Object[])new Object[]{"the quick brown fox jumped over the lazy dog", Long.MAX_VALUE, "01234".getBytes(StandardCharsets.UTF_8), true, Double.valueOf("99999999999999999999999999999999999999"), Double.MAX_VALUE, Date.valueOf("9999-12-31"), Float.valueOf(Float.MAX_VALUE), "[4,5,6,7]", "255.255.255.255", Integer.MAX_VALUE, "[4,5,6]", "{\"a\":1,\"b\":2}", "[4,5,6]", (short)Short.MAX_VALUE, "this is a text value", (byte)127, Timestamp.from(OffsetDateTime.of(9999, 12, 31, 23, 59, 59, 0, ZoneOffset.UTC).toInstant()), "d2177dd0-eaa2-11de-a572-001b779c76e3", "01234567-0123-0123-0123-0123456789ab", "abc", String.valueOf(Long.MAX_VALUE)}), QueryAssert.Row.row((Object[])new Object[]{"def", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testNationJoinNation() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        String sql = String.format("SELECT n1.n_name, n2.n_regionkey FROM %s n1 JOIN %s n2 ON n1.n_nationkey = n2.n_regionkey WHERE n1.n_nationkey=3", tableName, tableName);
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3}), QueryAssert.Row.row((Object[])new Object[]{"CANADA", 3})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testNationJoinRegion() {
        String sql = String.format("SELECT c.n_name, t.name FROM %s.%s.%s c JOIN tpch.tiny.region t ON c.n_regionkey = t.regionkey WHERE c.n_nationkey=3", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CANADA", "AMERICA"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectAllTypePartitioningMaterializedView() {
        String materializedViewName = String.format("%s_partitioned_mv", DataTypesTableDefinition.CASSANDRA_ALL_TYPES.getName());
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", materializedViewName));
        this.onCassandra(String.format("CREATE MATERIALIZED VIEW %s.%s AS SELECT * FROM %s.%s WHERE b IS NOT NULL PRIMARY KEY (a, b)", "test", materializedViewName, "test", DataTypesTableDefinition.CASSANDRA_ALL_TYPES.getName()));
        QueryAssertions.assertContainsEventually(() -> QueryExecutors.onTrino().executeQuery(String.format("SHOW TABLES FROM %s.%s", "cassandra", "test"), new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery(String.format("SELECT '%s'", materializedViewName), new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryAssertions.assertContainsEventually(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT status_replicated FROM %s.system.built_views WHERE view_name = '%s'", "cassandra", materializedViewName), new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT true", new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryResult query = QueryExecutors.onTrino().executeQuery(String.format("SELECT a, b, bl, bo, d, do, dt, f, fr, i, integer, l, m, s, si, t, ti, ts, tu, u, v, vari FROM %s.%s.%s WHERE a = '\u0000'", "cassandra", "test", materializedViewName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)query).hasColumns(new JDBCType[]{JDBCType.VARCHAR, JDBCType.BIGINT, JDBCType.VARBINARY, JDBCType.BOOLEAN, JDBCType.DOUBLE, JDBCType.DOUBLE, JDBCType.DATE, JDBCType.REAL, JDBCType.VARCHAR, JDBCType.JAVA_OBJECT, JDBCType.INTEGER, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.SMALLINT, JDBCType.VARCHAR, JDBCType.TINYINT, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.JAVA_OBJECT, JDBCType.JAVA_OBJECT, JDBCType.VARCHAR, JDBCType.VARCHAR}).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"\u0000", Long.MIN_VALUE, new byte[]{0}, false, Float.valueOf(0.0f), Double.MIN_VALUE, Date.valueOf("1970-01-02"), Float.valueOf(Float.MIN_VALUE), "[0]", "0.0.0.0", Integer.MIN_VALUE, "[0]", "{\"\\u0000\":-2147483648,\"a\":0}", "[0]", (short)Short.MIN_VALUE, "\u0000", (byte)-128, Timestamp.from(OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant()), "d2177dd0-eaa2-11de-a572-001b779c76e3", "01234567-0123-0123-0123-0123456789ab", "\u0000", String.valueOf(Long.MIN_VALUE)})});
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", materializedViewName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectClusteringMaterializedView() {
        String mvName = "clustering_mv";
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", mvName));
        this.onCassandra(String.format("CREATE MATERIALIZED VIEW %s.%s AS SELECT * FROM %s.%s WHERE s_nationkey IS NOT NULL PRIMARY KEY (s_nationkey, s_suppkey) WITH CLUSTERING ORDER BY (s_nationkey DESC)", "test", mvName, "test", CassandraTpchTableDefinitions.CASSANDRA_SUPPLIER.getName()));
        QueryAssertions.assertContainsEventually(() -> QueryExecutors.onTrino().executeQuery(String.format("SHOW TABLES FROM %s.%s", "cassandra", "test"), new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery(String.format("SELECT '%s'", mvName), new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryAssertions.assertContainsEventually(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT status_replicated FROM %s.system.built_views WHERE view_name = '%s'", "cassandra", mvName), new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT true", new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryResult aggregateQueryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT MAX(s_nationkey), SUM(s_suppkey), AVG(s_acctbal) FROM %s.%s.%s WHERE s_suppkey BETWEEN 1 AND 10 ", "cassandra", "test", mvName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)aggregateQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{24, 55, 4334.653})});
        QueryResult orderedResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT s_nationkey, s_suppkey, s_acctbal FROM %s.%s.%s ORDER BY s_nationkey LIMIT 1", "cassandra", "test", mvName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)orderedResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 24, 9170.71})});
        this.onCassandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", mvName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testProtocolVersion() {
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT native_protocol_version FROM %s.system.local", "cassandra"), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"4"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectTupleType() {
        String tableName = "select_tuple_table";
        this.onCassandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
        this.onCassandra(String.format("CREATE TABLE %s.%s (key int, value frozen<tuple<int, text, float>>, PRIMARY KEY (key))", "test", tableName));
        this.onCassandra(String.format("INSERT INTO %s.%s (key, value) VALUES(1, (1, 'text-1', 1.11))", "test", tableName));
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s.%s.%s", "cassandra", "test", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasRowsCount(1);
        Assertions.assertThat(queryResult.row(0).get(0)).isEqualTo((Object)1);
        Assertions.assertThat(queryResult.row(0).get(1)).isEqualTo((Object)Row.builder().addUnnamedField((Object)1).addUnnamedField((Object)"text-1").addUnnamedField((Object)Float.valueOf(1.11f)).build());
        this.onCassandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectTupleTypeInPrimaryKey() {
        String tableName = "select_tuple_in_primary_key_table";
        this.onCassandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
        this.onCassandra(String.format("CREATE TABLE %s.%s (intkey int, tuplekey frozen<tuple<int, text, float>>, PRIMARY KEY (intkey, tuplekey))", "test", tableName));
        this.onCassandra(String.format("INSERT INTO %s.%s (intkey, tuplekey) VALUES(1, (1, 'text-1', 1.11))", "test", tableName));
        Consumer<QueryResult> assertion = queryResult -> {
            QueryAssert.assertThat((QueryResult)queryResult).hasRowsCount(1);
            Assertions.assertThat(queryResult.row(0).get(0)).isEqualTo((Object)1);
            Assertions.assertThat(queryResult.row(0).get(1)).isEqualTo((Object)Row.builder().addUnnamedField((Object)1).addUnnamedField((Object)"text-1").addUnnamedField((Object)Float.valueOf(1.11f)).build());
        };
        assertion.accept(QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s.%s.%s", "cassandra", "test", tableName), new QueryExecutor.QueryParam[0]));
        assertion.accept(QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s.%s.%s WHERE intkey = 1 and tuplekey = row(1, 'text-1', 1.11)", "cassandra", "test", tableName), new QueryExecutor.QueryParam[0]));
        this.onCassandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectUserDefinedType() {
        String udtName = "type_user_defined";
        String tableName = "user_defined_type_table";
        this.onCassandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
        this.onCassandra(String.format("DROP TYPE IF EXISTS %s.%s", "test", udtName));
        this.onCassandra(String.format("CREATE TYPE %s.%s (t text, u uuid, integer int, b bigint, bl blob, ts timestamp, a ascii, bo boolean, d decimal, do double, f float, i inet, v varchar, vari varint, tu timeuuid, l frozen <list<text>>, m frozen <map<varchar, bigint>>, s frozen <set<boolean>> )", "test", udtName));
        this.onCassandra(String.format("CREATE TABLE %s.%s (key text PRIMARY KEY, typeudt frozen <%s>, )", "test", tableName, udtName));
        this.onCassandra(String.format("INSERT INTO %s.%s (key, typeudt) VALUES ('key',{ t: 'text', u: 01234567-0123-0123-0123-0123456789ab, integer: -2147483648, b:  -9223372036854775808,bl: 0x3031323334, ts: '1970-01-01 13:30:00.000', a: 'ansi', bo: true, d: 99999999999999997748809823456034029568, do: 4.9407e-324, f: 1.4013e-45, i: '0.0.0.0', v: 'varchar', vari: -9223372036854775808, tu: d2177dd0-eaa2-11de-a572-001b779c76e3, l: ['list'], m: {'map': 1}, s: {true} })", "test", tableName));
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT typeudt.t, typeudt.u, typeudt.integer, typeudt.b, typeudt.bl, typeudt.ts, typeudt.a, typeudt.bo, typeudt.d, typeudt.do, typeudt.f, typeudt.i, typeudt.v, typeudt.vari, typeudt.tu, typeudt.l, typeudt.m, typeudt.s FROM %s.%s.%s", "cassandra", "test", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"text", "01234567-0123-0123-0123-0123456789ab", Integer.MIN_VALUE, Long.MIN_VALUE, "01234".getBytes(StandardCharsets.UTF_8), Timestamp.valueOf(LocalDateTime.of(1970, 1, 1, 13, 30)), "ansi", true, 1.0E38, Double.MIN_VALUE, Float.valueOf(Float.MIN_VALUE), "0.0.0.0", "varchar", "-9223372036854775808", "d2177dd0-eaa2-11de-a572-001b779c76e3", "[\"list\"]", "{\"map\":1}", "[true]"})});
        this.onCassandra(String.format("DROP TABLE %s.%s", "test", tableName));
        this.onCassandra(String.format("DROP TYPE %s.%s", "test", udtName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectUserDefinedTypeInPrimaryKey() {
        String udtName = "type_user_defined_primary_key";
        String tableName = "select_udt_in_primary_key_table";
        this.onCassandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
        this.onCassandra(String.format("DROP TYPE IF EXISTS %s.%s", "test", udtName));
        this.onCassandra(String.format("CREATE TYPE %s.%s (field1 text)", "test", udtName));
        this.onCassandra(String.format("CREATE TABLE %s.%s (intkey int, udtkey frozen<%s>, PRIMARY KEY (intkey, udtkey))", "test", tableName, udtName));
        this.onCassandra(String.format("INSERT INTO %s.%s (intkey, udtkey) VALUES(1, {field1: 'udt-1'})", "test", tableName));
        Consumer<QueryResult> assertion = queryResult -> {
            QueryAssert.assertThat((QueryResult)queryResult).hasRowsCount(1);
            Assertions.assertThat(queryResult.row(0).get(0)).isEqualTo((Object)1);
            Assertions.assertThat(queryResult.row(0).get(1)).isEqualTo((Object)Row.builder().addField("field1", (Object)"udt-1").build());
        };
        assertion.accept(QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s.%s.%s", "cassandra", "test", tableName), new QueryExecutor.QueryParam[0]));
        assertion.accept(QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s.%s.%s WHERE intkey = 1 AND udtkey = CAST(ROW('udt-1') AS ROW(x VARCHAR))", "cassandra", "test", tableName), new QueryExecutor.QueryParam[0]));
        this.onCassandra(String.format("DROP TABLE %s.%s", "test", tableName));
        this.onCassandra(String.format("DROP TYPE %s.%s", "test", udtName));
    }

    private void onCassandra(String query) {
        try (CassandraQueryExecutor queryExecutor = new CassandraQueryExecutor(this.configuration);){
            queryExecutor.executeQuery(query);
        }
    }
}

