/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeCheckConstraintCompatibility
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"}, dataProvider="checkConstraints")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCheckConstraintCompatibility(String columnDefinition, String checkConstraint, String validInput, QueryAssert.Row insertedValue, String invalidInput) {
        String tableName = "test_check_constraint_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(" + columnDefinition + ") USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD CONSTRAINT a_constraint CHECK (" + checkConstraint + ")", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (" + validInput + ")", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{insertedValue});
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (" + validInput + ")", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{insertedValue, insertedValue});
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (" + invalidInput + ")", new QueryExecutor.QueryParam[0])).hasMessageMatching("(?s).* CHECK constraint .* violated by row with values.*");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (" + invalidInput + ")", new QueryExecutor.QueryParam[0])).hasMessageContaining("Check constraint violation");
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{insertedValue, insertedValue});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @DataProvider
    public static Object[][] checkConstraints() {
        return new Object[][]{{"a INT", "a = 1", "1", QueryAssert.Row.row((Object[])new Object[]{1}), "2"}, {"a INT", "a > 1", "2", QueryAssert.Row.row((Object[])new Object[]{2}), "1"}, {"a INT", "a >= 1", "1", QueryAssert.Row.row((Object[])new Object[]{1}), "0"}, {"a INT", "a < 1", "0", QueryAssert.Row.row((Object[])new Object[]{0}), "1"}, {"a INT", "a <= 1", "1", QueryAssert.Row.row((Object[])new Object[]{1}), "2"}, {"a INT", "a <> 1", "2", QueryAssert.Row.row((Object[])new Object[]{2}), "1"}, {"a INT", "a != 1", "2", QueryAssert.Row.row((Object[])new Object[]{2}), "1"}, {"a INT, b INT", "a = b + 1", "2, 1", QueryAssert.Row.row((Object[])new Object[]{2, 1}), "2, 2"}, {"a INT, b INT", "a = b - 1", "1, 2", QueryAssert.Row.row((Object[])new Object[]{1, 2}), "1, 3"}, {"a INT, b INT", "a = b * 2", "4, 2", QueryAssert.Row.row((Object[])new Object[]{4, 2}), "4, 3"}, {"a INT, b INT", "a = b / 2", "2, 4", QueryAssert.Row.row((Object[])new Object[]{2, 4}), "2, 6"}, {"a INT, b INT", "a = b % 2", "1, 5", QueryAssert.Row.row((Object[])new Object[]{1, 5}), "1, 6"}, {"a INT, b INT", "a = b & 5", "1, 3", QueryAssert.Row.row((Object[])new Object[]{1, 3}), "1, 4"}, {"a INT, b INT", "a = b ^ 5", "6, 3", QueryAssert.Row.row((Object[])new Object[]{6, 3}), "6, 4"}, {"a INT", "a < 100", "1", QueryAssert.Row.row((Object[])new Object[]{1}), "100"}, {"a STRING", "a = 'valid'", "'valid'", QueryAssert.Row.row((Object[])new Object[]{"valid"}), "'invalid'"}, {"a STRING", "a = \"double-quote\"", "'double-quote'", QueryAssert.Row.row((Object[])new Object[]{"double-quote"}), "'invalid'"}, {"`a.dot` INT", "`a.dot` = 1", "1", QueryAssert.Row.row((Object[])new Object[]{1}), "2"}};
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCheckConstraintAcrossColumns() {
        String tableName = "test_check_constraint_across_columns_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD CONSTRAINT a_constraint CHECK (a = b)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 1)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 1})});
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0])).hasMessageMatching("(?s).* CHECK constraint .* violated by row with values.*");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Check constraint violation");
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 1})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "delta-lake-databricks", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testWritesToTableWithCheckConstraintFails() {
        String tableName = "test_check_constraint_unsupported_operatins_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a INT, b INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD CONSTRAINT aIsPositive CHECK (a > 0)", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a = 3 WHERE b = 3", new QueryExecutor.QueryParam[0])).hasMessageContaining("Updating a table with a check constraint is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a = 3", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with CHECK constraints is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.a = s.a) WHEN MATCHED THEN UPDATE SET b = 42", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot merge into a table with check constraints");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "delta-lake-databricks", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testMetadataOperationsRetainCheckConstraint() {
        String tableName = "test_metadata_operations_retain_check_constraints_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a INT, b INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD CONSTRAINT aIsPositive CHECK (a > 0)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN c INT", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".c IS 'example column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'example table comment'", new QueryExecutor.QueryParam[0]);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

