/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.fulfillment.table.hive.HiveDataSource;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.fulfillment.table.hive.InlineDataSource;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Locale;
import java.util.Optional;

public final class AllSimpleTypesTableDefinitions {
    private static String tableNameFormat = "%s_all_types";
    public static final HiveTableDefinition ALL_HIVE_SIMPLE_TYPES_TEXTFILE = AllSimpleTypesTableDefinitions.tableDefinitionBuilder("TEXTFILE", Optional.of("DELIMITED FIELDS TERMINATED BY '|'")).setDataSource(AllSimpleTypesTableDefinitions.getTextFileDataSource()).build();
    public static final HiveTableDefinition ALL_HIVE_SIMPLE_TYPES_PARQUET = AllSimpleTypesTableDefinitions.parquetTableDefinitionBuilder().setNoData().build();
    public static final HiveTableDefinition ALL_HIVE_SIMPLE_TYPES_AVRO = AllSimpleTypesTableDefinitions.avroTableDefinitionBuilder().setNoData().build();
    public static final HiveTableDefinition ALL_HIVE_SIMPLE_TYPES_ORC = AllSimpleTypesTableDefinitions.tableDefinitionBuilder("ORC", Optional.empty()).setNoData().build();
    public static final HiveTableDefinition ALL_HIVE_SIMPLE_TYPES_RCFILE = AllSimpleTypesTableDefinitions.tableDefinitionBuilder("RCFILE", Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'")).setNoData().build();

    private AllSimpleTypesTableDefinitions() {
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat, Optional<String> rowFormat) {
        String tableName = String.format(tableNameFormat, fileFormat.toLowerCase(Locale.ENGLISH));
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE %EXTERNAL% TABLE %NAME%(   c_tinyint            TINYINT,   c_smallint           SMALLINT,   c_int                INT,   c_bigint             BIGINT,   c_float              FLOAT,   c_double             DOUBLE,   c_decimal            DECIMAL,   c_decimal_w_params   DECIMAL(10,5),   c_timestamp          TIMESTAMP,   c_date               DATE,   c_string             STRING,   c_varchar            VARCHAR(10),   c_char               CHAR(10),   c_boolean            BOOLEAN,   c_binary             BINARY) " + (String)(rowFormat.isPresent() ? "ROW FORMAT " + rowFormat.get() + " " : " ") + "STORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder avroTableDefinitionBuilder() {
        return HiveTableDefinition.builder((String)"avro_all_types").setCreateTableDDLTemplate("CREATE %EXTERNAL% TABLE %NAME%(   c_int                INT,   c_bigint             BIGINT,   c_float              FLOAT,   c_double             DOUBLE,   c_decimal            DECIMAL,   c_decimal_w_params   DECIMAL(10,5),   c_timestamp          TIMESTAMP,   c_date               DATE,   c_string             STRING,   c_varchar            VARCHAR(10),   c_char               CHAR(10),   c_boolean            BOOLEAN,   c_binary             BINARY) STORED AS AVRO");
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder parquetTableDefinitionBuilder() {
        return HiveTableDefinition.builder((String)"parquet_all_types").setCreateTableDDLTemplate("CREATE %EXTERNAL% TABLE %NAME%(   c_tinyint            TINYINT,   c_smallint           SMALLINT,   c_int                INT,   c_bigint             BIGINT,   c_float              FLOAT,   c_double             DOUBLE,   c_decimal            DECIMAL,   c_decimal_w_params   DECIMAL(10,5),   c_timestamp          TIMESTAMP,   c_string             STRING,   c_varchar            VARCHAR(10),   c_char               CHAR(10),   c_boolean            BOOLEAN,   c_binary             BINARY) STORED AS PARQUET");
    }

    private static HiveDataSource getTextFileDataSource() {
        return InlineDataSource.createResourceDataSource((String)String.format(tableNameFormat, "textfile"), (String)"io/trino/tests/product/hive/data/all_types/data.textfile");
    }

    public static void populateDataToHiveTable(String tableName) {
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT * FROM %s", tableName, String.format(tableNameFormat, "textfile")), new QueryExecutor.QueryParam[0]);
    }
}

