/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Objects;
import org.testng.annotations.Test;

public class TestAzureBlobFileSystem
extends ProductTest {
    private String schemaLocation;

    @BeforeTestWithContext
    public void setUp() {
        String container = Objects.requireNonNull(System.getenv("ABFS_CONTAINER"), "Environment variable not set: ABFS_CONTAINER");
        String account = Objects.requireNonNull(System.getenv("ABFS_ACCOUNT"), "Environment variable not set: ABFS_ACCOUNT");
        this.schemaLocation = String.format("abfs://%s@%s.dfs.core.windows.net/%s", container, account, "test_" + TestingNames.randomNameSuffix());
        QueryExecutors.onHive().executeQuery("dfs -rm -f -r " + this.schemaLocation, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("dfs -mkdir -p " + this.schemaLocation, new QueryExecutor.QueryParam[0]);
    }

    @AfterTestWithContext
    public void tearDown() {
        QueryExecutors.onHive().executeQuery("dfs -mkdir -p " + this.schemaLocation, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testPathContainsSpecialCharacter() {
        String tableName = "test_path_special_character" + TestingNames.randomNameSuffix();
        String tableLocation = this.schemaLocation + "/" + tableName;
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (id bigint) PARTITIONED BY (part string) LOCATION '" + tableLocation + "'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO " + tableName + " VALUES (1, 'hive=equal'),(2, 'hive+plus'),(3, 'hive space'),(4, 'hive:colon'),(5, 'hive%percent')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES (11, 'trino=equal'),(12, 'trino+plus'),(13, 'trino space'),(14, 'trino:colon'),(15, 'trino%percent')", new QueryExecutor.QueryParam[0]);
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "hive=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "hive+plus"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "hive space"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "hive:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "hive%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{11, "trino=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{12, "trino+plus"}), (Object)QueryAssert.Row.row((Object[])new Object[]{13, "trino space"}), (Object)QueryAssert.Row.row((Object[])new Object[]{14, "trino:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{15, "trino%percent"}));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected);
        QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }
}

