/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.testng.annotations.Test;

public class TestIcebergOptimize
extends ProductTest {
    private static final String SPARK_CATALOG = "iceberg_test";
    private static final String TRINO_CATALOG = "iceberg";
    private static final String TEST_SCHEMA_NAME = "default";

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testOptimizeTableAfterDelete() {
        String baseTableName = "test_optimize_with_small_split_size_" + TestingNames.randomNameSuffix();
        String trinoTableName = TestIcebergOptimize.trinoTableName(baseTableName);
        String sparkTableName = TestIcebergOptimize.sparkTableName(baseTableName);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + trinoTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + trinoTableName + "(regionkey integer, country varchar, description varchar) ", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + trinoTableName + " VALUES (1, 'Poland', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque rutrum erat faucibus tempus ullamcorper. Duis at auctor est, a accumsan magna.'), (1, 'Austria', ' Aliquam rhoncus tortor eu sagittis vulputate. Donec non erat nec dui tempor mattis pellentesque quis sapien. Proin dolor elit, porttitor aliquam erat et, aliquam eleifend elit. '), (1, 'France', 'Cras et elit sed nisl faucibus volutpat sed ac sapien. Sed ut metus vulputate, feugiat massa sed, lacinia ipsum. Phasellus ultrices ligula non ultricies gravida'), (1, 'Germany', 'Suspendisse eu nunc in lectus blandit pretium posuere non libero. Donec eu ligula hendrerit, pellentesque risus et, luctus odio.'), (2, 'United States of America', 'Pellentesque fermentum, tellus eget laoreet aliquam, nibh libero sollicitudin augue, vel posuere tellus odio vel est. Integer ac sem malesuada nibh imperdiet placerat.'), (2, 'Canada', 'Pellentesque porta nisi vel viverra sodales. Praesent et magna venenatis, varius quam eget, tristique orci. In ac cursus felis, vel elementum odio.'), (3, 'Japan', 'Sed vitae dignissim mi, eu mattis ante. Nam vulputate augue magna, vel viverra diam interdum at. Phasellus vehicula ante sit amet cursus venenatis.'),(3, 'China', 'Fusce sit amet eleifend nunc. Maecenas bibendum felis felis, eu cursus neque viverra sed. Sed faucibus augue eu placerat elementum. Nam vitae hendrerit odio.'),(3, 'Laos', 'Nulla vel placerat nibh. Pellentesque a cursus nunc. In tristique sollicitudin vestibulum. Sed imperdiet justo eget rhoncus condimentum. In commodo, purus sit amet malesuada rutrum, neque magna euismod elit')", new QueryExecutor.QueryParam[0]);
        List<String> initialFiles = this.getActiveFiles(TRINO_CATALOG, TEST_SCHEMA_NAME, baseTableName);
        QueryExecutors.onTrino().executeQuery("DELETE FROM " + trinoTableName + " WHERE regionkey = 1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DELETE FROM " + trinoTableName + " WHERE regionkey = 2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT summary['total-delete-files'] FROM %s.%s.\"%s$snapshots\" ", TRINO_CATALOG, TEST_SCHEMA_NAME, baseTableName) + "WHERE snapshot_id = " + this.getCurrentSnapshotId(TRINO_CATALOG, TEST_SCHEMA_NAME, baseTableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"2"})});
        QueryExecutors.onSpark().executeQuery("ALTER TABLE " + sparkTableName + " SET TBLPROPERTIES ('read.split.target-size'='100')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + trinoTableName + " EXECUTE OPTIMIZE", new QueryExecutor.QueryParam[0]);
        List<String> updatedFiles = this.getActiveFiles(TRINO_CATALOG, TEST_SCHEMA_NAME, baseTableName);
        ((ListAssert)Assertions.assertThat(updatedFiles).hasSize(1)).isNotEqualTo(initialFiles);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3, "Japan", "Sed vitae dignissim mi, eu mattis ante. Nam vulputate augue magna, vel viverra diam interdum at. Phasellus vehicula ante sit amet cursus venenatis."}), QueryAssert.Row.row((Object[])new Object[]{3, "China", "Fusce sit amet eleifend nunc. Maecenas bibendum felis felis, eu cursus neque viverra sed. Sed faucibus augue eu placerat elementum. Nam vitae hendrerit odio."}), QueryAssert.Row.row((Object[])new Object[]{3, "Laos", "Nulla vel placerat nibh. Pellentesque a cursus nunc. In tristique sollicitudin vestibulum. Sed imperdiet justo eget rhoncus condimentum. In commodo, purus sit amet malesuada rutrum, neque magna euismod elit"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + trinoTableName, new QueryExecutor.QueryParam[0]);
    }

    private List<String> getActiveFiles(String catalog, String schema, String tableName) {
        return (List)QueryExecutors.onTrino().executeQuery(String.format("SELECT file_path FROM %s.%s.\"%s$files\"", catalog, schema, tableName), new QueryExecutor.QueryParam[0]).rows().stream().map(row -> (String)row.get(0)).collect(ImmutableList.toImmutableList());
    }

    private long getCurrentSnapshotId(String catalog, String schema, String tableName) {
        return (Long)QueryExecutors.onTrino().executeQuery(String.format("SELECT snapshot_id FROM %s.%s.\"%s$snapshots\" ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES", catalog, schema, tableName), new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    private static String sparkTableName(String tableName) {
        return String.format("%s.%s.%s", SPARK_CATALOG, TEST_SCHEMA_NAME, tableName);
    }

    private static String trinoTableName(String tableName) {
        return String.format("%s.%s.%s", TRINO_CATALOG, TEST_SCHEMA_NAME, tableName);
    }
}

