/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.minio.messages.EventType;
import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.minio.MinioClient;
import io.trino.tests.product.utils.MinioNotificationsAssertions;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Objects;
import org.testng.annotations.Test;

public abstract class BaseTestDeltaLakeMinioReads
extends ProductTest {
    protected static final String BUCKET_NAME = "delta-test-basic-reads";
    protected static final String NOTIFICATIONS_TABLE = "read_region_notifications";
    protected MinioClient client;
    protected String tableName;
    protected String regionResourcePath;

    public BaseTestDeltaLakeMinioReads(String regionTableName, String regionResourcePath) {
        this.tableName = Objects.requireNonNull(regionTableName, "regionTableName is null");
        this.regionResourcePath = Objects.requireNonNull(regionResourcePath, "regionResourcePath is null");
    }

    @BeforeTestWithContext
    public void setUp() {
        this.client = new MinioClient();
        MinioNotificationsAssertions.deleteNotificationsTable(NOTIFICATIONS_TABLE);
        MinioNotificationsAssertions.createNotificationsTable(NOTIFICATIONS_TABLE);
        this.client.copyResourcePath(BUCKET_NAME, this.regionResourcePath, this.tableName);
        this.client.captureBucketNotifications(BUCKET_NAME, notification -> MinioNotificationsAssertions.recordNotification(NOTIFICATIONS_TABLE, notification));
    }

    @AfterTestWithContext
    public void tearDown() {
        MinioNotificationsAssertions.deleteNotificationsTable(NOTIFICATIONS_TABLE);
        this.client.close();
        this.client = null;
    }

    @Test(groups={"delta-lake-minio", "profile_specific_tests"})
    public void testReadRegionTable() {
        QueryExecutors.onTrino().executeQuery(String.format("CALL delta.system.register_table('default', '%1$s', 's3://%2$s/%1$s')", this.tableName, BUCKET_NAME), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(name) FROM delta.default.\"%s\"", this.tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5L})});
        MinioNotificationsAssertions.assertNotificationsCount(NOTIFICATIONS_TABLE, EventType.OBJECT_ACCESSED_HEAD, this.tableName + "/_delta_log/00000000000000000000.json", 0);
        MinioNotificationsAssertions.assertNotificationsCount(NOTIFICATIONS_TABLE, EventType.OBJECT_ACCESSED_GET, this.tableName + "/_delta_log/00000000000000000000.json", 1);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE delta.default.\"%s\"", this.tableName), new QueryExecutor.QueryParam[0]);
    }
}

