/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class, ImmutableTpchTablesRequirements.ImmutableOrdersTable.class, ImmutableTpchTablesRequirements.ImmutableRegionTable.class})
public abstract class AbstractTestHiveViews
extends HiveProductTest {
    @Test(groups={"hive_views"})
    public void testSelectOnView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_test_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_test_view", queryAssert -> queryAssert.hasRowsCount(25));
        AbstractTestHiveViews.assertViewQuery("SELECT n_nationkey, n_name, n_regionkey, n_comment FROM hive_test_view WHERE n_nationkey < 3", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, "ALGERIA", 0, " haggle. carefully final deposits detect slyly agai"}), QueryAssert.Row.row((Object[])new Object[]{1, "ARGENTINA", 1, "al foxes promise slyly according to the regular accounts. bold requests alon"}), QueryAssert.Row.row((Object[])new Object[]{2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special "})}));
    }

    @Test(groups={"hive_views"})
    public void testArrayIndexingInView() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_hive_view_array_index_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_hive_view_array_index_table(an_index int, an_array array<string>)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE test_hive_view_array_index_table SELECT 1, array('presto','hive') FROM nation WHERE n_nationkey = 1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_hive_view_array_index_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_hive_view_array_index_view AS SELECT an_array[1] AS sql_dialect FROM test_hive_view_array_index_table", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_hive_view_array_index_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive"})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_hive_view_expression_array_index_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_hive_view_expression_array_index_view AS SELECT an_array[an_index] AS sql_dialect FROM test_hive_view_array_index_table", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_hive_view_expression_array_index_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive"})}));
    }

    @Test(groups={"hive_views"})
    public void testCommonTableExpression() {
        QueryExecutors.onHive().executeQuery("CREATE OR REPLACE VIEW test_common_table_expression AS WITH t AS (SELECT n_nationkey, n_regionkey FROM nation WHERE n_nationkey = 8) SELECT * FROM t", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_common_table_expression", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{8, 2})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW test_common_table_expression", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testNestedCommonTableExpression() {
        QueryExecutors.onHive().executeQuery("CREATE OR REPLACE VIEW test_nested_common_table_expression AS WITH t AS (SELECT n_nationkey, n_regionkey FROM nation WHERE n_nationkey = 8), t2 AS (SELECT n_nationkey * 2 AS nationkey, n_regionkey * 2 AS regionkey FROM t) SELECT * FROM t2", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_nested_common_table_expression", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{16, 4})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW test_nested_common_table_expression", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testArrayConstructionInView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_array_construction_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_array_construction_view AS SELECT n_nationkey, array(n_nationkey, n_regionkey) AS a FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT a[0], a[1] FROM test_array_construction_view WHERE n_nationkey = 8", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{8, 2})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a[1], a[2] FROM test_array_construction_view WHERE n_nationkey = 8", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{8, 2})});
    }

    @Test(groups={"hive_views"})
    public void testMapConstructionInView() {
        QueryExecutors.onHive().executeQuery("CREATE OR REPLACE VIEW test_map_construction_view AS SELECT  o_orderkey, MAP(o_clerk, o_orderpriority) AS simple_map, MAP(o_clerk, MAP(o_orderpriority, o_shippriority)) AS nested_map FROM orders", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT simple_map['Clerk#000000951'] FROM test_map_construction_view WHERE o_orderkey = 1", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"5-LOW"})}));
        AbstractTestHiveViews.assertViewQuery("SELECT nested_map['Clerk#000000951']['5-LOW'] FROM test_map_construction_view WHERE o_orderkey = 1", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW test_map_construction_view", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testSelectOnViewFromDifferentSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_schema.hive_test_view_1 AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_schema.hive_test_view_1", queryAssert -> queryAssert.hasRowsCount(25));
    }

    @Test(groups={"hive_views"})
    public void testViewReferencingTableInDifferentSchema() {
        String schemaX = "test_view_table_in_different_schema_x" + TestingNames.randomNameSuffix();
        String schemaY = "test_view_table_in_different_schema_y" + TestingNames.randomNameSuffix();
        String tableName = "test_table";
        String viewName = "test_view";
        QueryExecutors.onHive().executeQuery(String.format("CREATE SCHEMA %s", schemaX), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE SCHEMA %s", schemaY), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.%s AS SELECT * FROM tpch.tiny.nation", schemaY, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE VIEW %s.%s AS SELECT * FROM %s.%s", schemaX, viewName, schemaY, tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT COUNT(*) FROM %s.%s", schemaX, viewName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryExecutors.onHive().executeQuery(String.format("DROP SCHEMA %s CASCADE", schemaX), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("DROP SCHEMA %s CASCADE", schemaY), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testViewReferencingTableInTheSameSchemaWithoutQualifier() {
        String schemaX = "test_view_table_same_schema_without_qualifier_schema" + TestingNames.randomNameSuffix();
        String tableName = "test_table";
        String viewName = "test_view";
        QueryExecutors.onHive().executeQuery(String.format("CREATE SCHEMA %s", schemaX), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.%s AS SELECT * FROM tpch.tiny.nation", schemaX, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("USE %s", schemaX), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE VIEW %s AS SELECT * FROM %s", viewName, tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT COUNT(*) FROM %s.%s", schemaX, viewName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryExecutors.onHive().executeQuery(String.format("DROP SCHEMA %s CASCADE", schemaX), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testViewWithUnsupportedCoercion() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_unsupported_coercion", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_unsupported_coercion AS SELECT length(n_comment) FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT COUNT(*) FROM view_with_unsupported_coercion", new QueryExecutor.QueryParam[0])).hasMessageContaining("View 'hive.default.view_with_unsupported_coercion' is stale or in invalid state: a column of type bigint projected from query view at position 0 has no name");
    }

    @Test(groups={"hive_views"})
    public void testOuterParentheses() {
        if (this.getHiveVersionMajor() <= 1) {
            throw new SkipException("The old Hive doesn't allow outer parentheses in a view definition");
        }
        QueryExecutors.onHive().executeQuery("CREATE OR REPLACE VIEW view_outer_parentheses AS (SELECT 'parentheses' AS col FROM nation LIMIT 1)", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM view_outer_parentheses", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"parentheses"})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW view_outer_parentheses", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testDateFunction() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_date_function", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_date_function(s string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO hive_table_date_function (s) values ('2021-08-21')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE OR REPLACE VIEW hive_view_date_function AS SELECT date(s) AS col FROM hive_table_date_function", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_view_date_function", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{AbstractTestHiveViews.sqlDate(2021, 8, 21)})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW hive_view_date_function", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE hive_table_date_function", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testPmodFunction() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_pmod_function", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_pmod_function(n int, m int)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO hive_table_pmod_function (n, m) values (-5, 2)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE OR REPLACE VIEW hive_view_pmod_function AS SELECT pmod(n, m) AS col FROM hive_table_pmod_function", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_view_pmod_function", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW hive_view_pmod_function", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE hive_table_pmod_function", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testWithUnsupportedFunction() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_repeat_function", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_repeat_function AS SELECT REPEAT(n_comment,2) FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT COUNT(*) FROM view_with_repeat_function", new QueryExecutor.QueryParam[0])).hasMessageContaining("View 'hive.default.view_with_repeat_function' is stale or in invalid state: a column of type array(varchar(152)) projected from query view at position 0 has no name");
    }

    @Test(groups={"hive_views"})
    public void testExistingView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_duplicate_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0])).hasMessageContaining("View already exists");
    }

    @Test(groups={"hive_views"})
    public void testShowCreateView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_show_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_show_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        String showCreateViewSql = "SHOW CREATE VIEW %s.default.hive_show_view";
        String expectedResult = "CREATE VIEW %s.default.hive_show_view SECURITY DEFINER AS\nSELECT\n  \"n_nationkey\"\n, \"n_name\"\n, \"n_regionkey\"\n, \"n_comment\"\nFROM\n  \"default\".\"nation\"";
        QueryResult actualResult = QueryExecutors.onTrino().executeQuery(String.format(showCreateViewSql, "hive"), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actualResult).hasRowsCount(1);
        Assert.assertEquals((String)((String)actualResult.getOnlyValue()), (String)String.format(expectedResult, "hive"));
        actualResult = QueryExecutors.onTrino().executeQuery(String.format(showCreateViewSql, "hive_with_external_writes"), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actualResult).hasRowsCount(1);
        Assert.assertEquals((String)((String)actualResult.getOnlyValue()), (String)String.format(expectedResult, "hive_with_external_writes"));
    }

    @Test(groups={"hive_views"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testRichSqlSyntax() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_with_rich_syntax", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_with_rich_syntax AS SELECT \n   `n_nationkey`, \n   n_name, \n   `n_regionkey` AS `n_regionkey`, \n   n_regionkey BETWEEN 1 AND 2 AS region_between_1_2, \n   IF(`n`.`n_name` IN ('ALGERIA', 'ARGENTINA'), 1, 0) AS `starts_with_a`, \n   IF(`n`.`n_name` != 'PERU', 1, 0) `not_peru`, \n   IF(`n`.`n_name` LIKE '%N%', 1, 0) `CONTAINS_N`, \n   CASE WHEN n_name = \"BRAZIL\" THEN 'is BRAZIL' WHEN n_name = \"ALGERIA\" THEN 'is ALGERIA' ELSE \"\" END is_something,\n   COALESCE(IF(n_name LIKE 'A%', NULL, n_name), 'A%') AS coalesced_name, \n   round(tan(n_nationkey), 3) AS rounded_tan, \n   o_orderdate AS the_orderdate, \n   `n`.`n_nationkey` + `n_nationkey` + n.n_nationkey + n_nationkey + 10000 - -1 AS arithmetic--some comment without leading space \nFROM `default`.`nation` AS `n` \nLEFT JOIN (SELECT * FROM orders WHERE o_custkey > 1000) `o` ON `o`.`o_orderkey` = `n`.`n_nationkey` ", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT   n_nationkey, n_name, region_between_1_2, starts_with_a, not_peru, contains_n, is_something, coalesced_name,   rounded_tan, the_orderdate, arithmetic FROM view_with_rich_syntax WHERE n_regionkey < 3 AND (n_nationkey < 5 OR n_nationkey IN (12, 17))", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, "ALGERIA", false, 1, 1, 0, "is ALGERIA", "A%", 0.0, null, 10001}), QueryAssert.Row.row((Object[])new Object[]{1, "ARGENTINA", true, 1, 1, 1, "", "A%", 1.557, AbstractTestHiveViews.sqlDate(1996, 1, 2), 10005}), QueryAssert.Row.row((Object[])new Object[]{2, "BRAZIL", true, 0, 1, 0, "is BRAZIL", "BRAZIL", -2.185, AbstractTestHiveViews.sqlDate(1996, 12, 1), 10009}), QueryAssert.Row.row((Object[])new Object[]{3, "CANADA", true, 0, 1, 1, "", "CANADA", -0.143, AbstractTestHiveViews.sqlDate(1993, 10, 14), 10013}), QueryAssert.Row.row((Object[])new Object[]{12, "JAPAN", true, 0, 1, 1, "", "JAPAN", -0.636, null, 10049}), QueryAssert.Row.row((Object[])new Object[]{17, "PERU", true, 0, 0, 0, "", "PERU", 3.494, null, 10069})}));
    }

    @Test(groups={"hive_views"})
    public void testIdentifierThatStartWithDigit() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS \"7_table_with_number\"", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE \"7_table_with_number\" WITH (format='TEXTFILE') AS SELECT VARCHAR 'abc' x", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS view_on_identifiers_starting_with_numbers", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW view_on_identifiers_starting_with_numbers AS SELECT * FROM 7_table_with_number", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM view_on_identifiers_starting_with_numbers", queryAssert -> queryAssert.contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"abc"})}));
    }

    @Test(groups={"hive_views"})
    public void testHiveViewInInformationSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_schema.hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_schema.hive_table(a string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_schema.trino_table(a int)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW test_schema.trino_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        boolean hiveWithTableNamesByType = this.getHiveVersionMajor() >= 3 || this.getHiveVersionMajor() == 2 && this.getHiveVersionMinor() >= 3;
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM information_schema.tables WHERE table_schema = 'test_schema'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "trino_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_test_view", hiveWithTableNamesByType ? "VIEW" : "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "trino_test_view", "VIEW"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT view_definition FROM information_schema.views WHERE table_schema = 'test_schema' and table_name = 'hive_test_view'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"SELECT \"n_nationkey\", \"n_name\", \"n_regionkey\", \"n_comment\"\nFROM \"default\".\"nation\""})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DESCRIBE test_schema.hive_test_view", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", "bigint", "", ""})});
    }

    @Test(groups={"hive_views"})
    public void testHiveViewWithParametrizedTypes() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_view_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_parametrized(a decimal(20,4), b bigint, c varchar(20))", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_view_parametrized AS SELECT * FROM hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE hive_table_parametrized VALUES (1.2345, 42, 'bar')", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_view_parametrized", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("1.2345"), 42, "bar"})}));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT data_type FROM information_schema.columns WHERE table_name = 'hive_view_parametrized'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"bigint"}), QueryAssert.Row.row((Object[])new Object[]{"varchar"})});
    }

    @Test(groups={"hive_views"})
    public void testHiveViewWithTextualTypes() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_view_textual", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_textual", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_textual(a_char_1 char(1), a_char_255 char(255), a_varchar_1 varchar(1), a_varchar_65535 varchar(65535), a_string string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_view_textual AS SELECT * FROM hive_table_textual", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE hive_table_textual VALUES ('a', 'rainy', 'i', 'calendar', 'Boston Red Sox')", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM hive_view_textual", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", Strings.padEnd((String)"rainy", (int)255, (char)' '), "i", "calendar", "Boston Red Sox"})}));
        AbstractTestHiveViews.assertViewQuery("SELECT a_char_1, a_varchar_65535 FROM hive_view_textual WHERE a_string = 'Boston Red Sox'", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", "calendar"})}));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = 'hive_view_textual'", new QueryExecutor.QueryParam[0])).containsOnly(this.getExpectedHiveViewTextualColumnsTypes());
        QueryExecutors.onHive().executeQuery("DROP VIEW hive_view_textual", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE hive_table_textual", new QueryExecutor.QueryParam[0]);
    }

    protected abstract List<QueryAssert.Row> getExpectedHiveViewTextualColumnsTypes();

    @Test(groups={"hive_views"})
    public void testNestedHiveViews() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS nested_base_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS nested_middle_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS nested_top_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW nested_base_view AS SELECT n_nationkey as k, n_name as n, n_regionkey as r, n_comment as c FROM nation", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW nested_middle_view AS SELECT n, c FROM nested_base_view WHERE k = 14", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW nested_top_view AS SELECT n AS n_renamed FROM nested_middle_view", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT n_renamed FROM nested_top_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"KENYA"})}));
    }

    @Test(groups={"hive_views"})
    public void testSelectFromHiveViewWithoutDefaultCatalogAndSchema() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS no_catalog_schema_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW no_catalog_schema_view AS SELECT * FROM nation WHERE n_nationkey = 1", new QueryExecutor.QueryParam[0]);
        QueryExecutor executor = this.connectToTrino("presto_no_default_catalog");
        QueryAssert.assertQueryFailure(() -> executor.executeQuery("SELECT count(*) FROM no_catalog_schema_view", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Schema must be specified when session schema is not set.*");
        QueryAssert.assertThat((QueryResult)executor.executeQuery("SELECT count(*) FROM hive.default.no_catalog_schema_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1L})});
    }

    @Test(groups={"hive_views"})
    public void testTimestampHiveView() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS timestamp_hive_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE timestamp_hive_table (ts timestamp)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO timestamp_hive_table (ts) values ('1990-01-02 12:13:14.123456789')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS timestamp_hive_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW timestamp_hive_view AS SELECT * FROM timestamp_hive_table", new QueryExecutor.QueryParam[0]);
        this.unsetSessionProperty("hive.timestamp_precision");
        this.unsetSessionProperty("hive_timestamp_nanos.timestamp_precision");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT CAST(ts AS varchar) FROM timestamp_hive_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT CAST(ts AS varchar) FROM hive_timestamp_nanos.default.timestamp_hive_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123456789"})});
        this.setSessionProperty("hive.timestamp_precision", "'MILLISECONDS'");
        this.setSessionProperty("hive_timestamp_nanos.timestamp_precision", "'MILLISECONDS'");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT CAST(ts AS varchar) FROM timestamp_hive_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT CAST(ts AS varchar) FROM hive_timestamp_nanos.default.timestamp_hive_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123456789"})});
        this.setSessionProperty("hive.timestamp_precision", "'NANOSECONDS'");
        this.setSessionProperty("hive_timestamp_nanos.timestamp_precision", "'NANOSECONDS'");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT CAST(ts AS varchar) FROM timestamp_hive_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT CAST(ts AS varchar) FROM hive_timestamp_nanos.default.timestamp_hive_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1990-01-02 12:13:14.123456789"})});
    }

    @Test(groups={"hive_views"})
    public void testCurrentUser() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS current_user_hive_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW current_user_hive_view as SELECT current_user() AS cu FROM nation LIMIT 1", new QueryExecutor.QueryParam[0]);
        String testQuery = "SELECT cu FROM current_user_hive_view";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(testQuery, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive"})});
        QueryAssert.assertThat((QueryResult)this.connectToTrino("alice@presto").executeQuery(testQuery, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice"})});
    }

    @Test(groups={"hive_views"})
    public void testNestedGroupBy() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_nested_group_by_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_nested_group_by_view AS SELECT n_regionkey, count(1) count FROM (SELECT n_regionkey FROM nation GROUP BY n_regionkey ) t GROUP BY n_regionkey", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_nested_group_by_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 1}), QueryAssert.Row.row((Object[])new Object[]{1, 1}), QueryAssert.Row.row((Object[])new Object[]{2, 1}), QueryAssert.Row.row((Object[])new Object[]{3, 1}), QueryAssert.Row.row((Object[])new Object[]{4, 1})}));
    }

    @Test(groups={"hive_views"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testUnionAllViews() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS union_helper", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE union_helper (\nr_regionkey BIGINT,\nr_name VARCHAR(25),\nr_comment VARCHAR(152)\n)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO union_helper\nSELECT r_regionkey % 3, r_name, r_comment FROM region", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS union_all_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW union_all_view AS\nSELECT r_regionkey FROM region\nUNION ALL\nSELECT r_regionkey FROM union_helper\n", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT r_regionkey FROM union_all_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4}), QueryAssert.Row.row((Object[])new Object[]{0}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{0}), QueryAssert.Row.row((Object[])new Object[]{1})});
    }

    @Test(groups={"hive_views"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testUnionDistinctViews() {
        if (this.getHiveVersionMajor() < 1 || this.getHiveVersionMajor() == 1 && this.getHiveVersionMinor() < 2) {
            throw new SkipException("UNION DISTINCT and plain UNION are not supported before Hive 1.2.0");
        }
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS union_helper", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE union_helper (\nr_regionkey BIGINT,\nr_name VARCHAR(25),\nr_comment VARCHAR(152)\n)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO union_helper\nSELECT r_regionkey % 3, r_name, r_comment FROM region", new QueryExecutor.QueryParam[0]);
        for (String operator : List.of("UNION", "UNION DISTINCT")) {
            String name = String.format("%s_view", operator.replace(" ", "_"));
            QueryExecutors.onHive().executeQuery(String.format("DROP VIEW IF EXISTS %s", name), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery(String.format("CREATE VIEW %s AS\nSELECT r_regionkey FROM region\n%s\nSELECT r_regionkey FROM union_helper\n", name, operator), new QueryExecutor.QueryParam[0]);
            AbstractTestHiveViews.assertViewQuery(String.format("SELECT r_regionkey FROM %s", name), assertion -> ((QueryAssert)assertion.as("View with %s", new Object[]{operator})).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4})}));
        }
    }

    @Test(groups={"hive_views"})
    public void testHivePartitionViews() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_view_partitioned_column", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_table_partitioned_column", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_table_partitioned_column(some_id VARCHAR(25), ds VARCHAR(25)) WITH (partitioned_by=array['ds'])", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_table_partitioned_column VALUES ('1', '2022-09-17')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_view_partitioned_column PARTITIONED ON (ds) AS SELECT some_id, ds FROM test_table_partitioned_column", new QueryExecutor.QueryParam[0]);
        String testQuery = "SELECT some_id, ds FROM test_view_partitioned_column";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(testQuery, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1", "2022-09-17"})});
        QueryExecutors.onHive().executeQuery("DROP VIEW test_view_partitioned_column", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE test_table_partitioned_column", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testViewReferencingHiveAndIcebergTables() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS iceberg.default.view_iceberg_table_actual_data", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS iceberg.default.view_iceberg_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_iceberg_view", new QueryExecutor.QueryParam[0]);
        String icebergTableData = "SELECT   true a_boolean,   1 an_integer,   BIGINT '1' a_bigint,  REAL '1e0' a_real,   1e0 a_double,   DECIMAL '13.1' a_short_decimal,   DECIMAL '123456789123456.123456789' a_long_decimal,   VARCHAR 'abc' an_unbounded_varchar,   X'abcd' a_varbinary,   DATE '2005-09-10' a_date,   0 a_last_column ";
        QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default.view_iceberg_table_actual_data AS " + icebergTableData, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default.view_iceberg_table AS TABLE iceberg.default.view_iceberg_table_actual_data", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_iceberg_view AS SELECT view_iceberg_table.*, r_regionkey, r_name FROM view_iceberg_table JOIN region ON an_integer = r_regionkey", new QueryExecutor.QueryParam[0]);
        String tableDescription = QueryExecutors.onHive().executeQuery("SHOW CREATE TABLE default.view_iceberg_table_actual_data", new QueryExecutor.QueryParam[0]).rows().stream().map(row -> (String)Iterables.getOnlyElement((Iterable)row)).collect(Collectors.joining());
        String location = AbstractTestHiveViews.extractMatch(tableDescription, "LOCATION\\s*'(?<location>[^']+)'", "location");
        String metadataLocation = AbstractTestHiveViews.extractMatch(tableDescription, "'metadata_location'='(?<location>[^']+\\.metadata\\.json)'", "location");
        QueryExecutors.onTrino().executeQuery("DROP TABLE iceberg.default.view_iceberg_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE default.view_iceberg_table (dummy_column int) ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe' STORED AS INPUTFORMAT 'org.apache.hadoop.mapred.FileInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat' LOCATION '" + location + "' TBLPROPERTIES ('table_type'='iceberg', 'metadata_location'='" + metadataLocation + "') ", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("TABLE iceberg.default.view_iceberg_table", new QueryExecutor.QueryParam[0])).containsOnly((List)QueryExecutors.onTrino().executeQuery(icebergTableData, new QueryExecutor.QueryParam[0]).rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onHive().executeQuery("SELECT * FROM hive_iceberg_view", new QueryExecutor.QueryParam[0])).hasMessageContaining("SemanticException").hasMessageContaining("Invalid column reference 'an_integer' in definition of VIEW hive_iceberg_view");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive_iceberg_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{true, 1, 1L, Float.valueOf(1.0f), 1.0, new BigDecimal("13.1"), new BigDecimal("123456789123456.123456789"), "abc", new byte[]{-85, -51}, Date.valueOf(LocalDate.of(2005, 9, 10)), 0, 1L, "AMERICA"})});
        QueryExecutors.onHive().executeQuery("DROP VIEW hive_iceberg_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE iceberg.default.view_iceberg_table_actual_data", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE default.view_iceberg_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testViewWithColumnAliasesDifferingInCase() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_hive_namesake_column_name_a", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_hive_namesake_column_name_b", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_hive_namesake_column_name_a(some_id string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_hive_namesake_column_name_b(SOME_ID string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE test_hive_namesake_column_name_a VALUES ('hive')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE test_hive_namesake_column_name_b VALUES (' hive ')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_namesake_column_names_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_namesake_column_names_view AS \n    SELECT a.some_id FROM test_hive_namesake_column_name_a a \n    LEFT JOIN (SELECT trim(SOME_ID) AS SOME_ID FROM test_hive_namesake_column_name_b) b \n       ON a.some_id = b.some_id \n    WHERE a.some_id != ''", new QueryExecutor.QueryParam[0]);
        AbstractTestHiveViews.assertViewQuery("SELECT * FROM test_namesake_column_names_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive"})}));
        QueryExecutors.onHive().executeQuery("DROP TABLE test_hive_namesake_column_name_a", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE test_hive_namesake_column_name_b", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW test_namesake_column_names_view", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testRunAsInvoker() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS run_as_invoker", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS run_as_invoker_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE run_as_invoker (a INTEGER)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW run_as_invoker_view AS SELECT * FROM run_as_invoker", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT SELECT ON hive_with_run_view_as_invoker.default.run_as_invoker_view TO hive", new QueryExecutor.QueryParam[0]);
        String definerQuery = "SELECT * FROM hive.default.run_as_invoker_view";
        String invokerQuery = "SELECT * FROM hive_with_run_view_as_invoker.default.run_as_invoker_view";
        QueryAssert.assertThat((QueryResult)this.connectToTrino("alice@presto").executeQuery(definerQuery, new QueryExecutor.QueryParam[0])).hasNoRows();
        Assertions.assertThatThrownBy(() -> this.connectToTrino("alice@presto").executeQuery(invokerQuery, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied");
        QueryExecutors.onHive().executeQuery("DROP VIEW run_as_invoker_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE run_as_invoker", new QueryExecutor.QueryParam[0]);
    }

    protected static void assertViewQuery(String query, Consumer<QueryAssert> assertion) {
        assertion.accept(QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery(query, new QueryExecutor.QueryParam[0])));
        assertion.accept(QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0])));
    }

    protected static Date sqlDate(int year, int month, int day) {
        return Date.valueOf(LocalDate.of(year, month, day));
    }

    protected QueryExecutor connectToTrino(String catalog) {
        return QueryExecutors.connectToTrino(catalog);
    }

    protected void setSessionProperty(String key, String value) {
        QueryExecutors.onTrino().executeQuery(String.format("SET SESSION %s = %s", key, value), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("SET SESSION %s = %s", key, value), new QueryExecutor.QueryParam[0]);
    }

    protected void unsetSessionProperty(String key) {
        QueryExecutors.onTrino().executeQuery("RESET SESSION " + key, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("RESET SESSION " + key, new QueryExecutor.QueryParam[0]);
    }

    private static String extractMatch(String value, @Language(value="RegExp") String pattern, String groupName) {
        Matcher matcher = Pattern.compile(pattern).matcher(value);
        Verify.verify((boolean)matcher.find(), (String)"Did not find match in [%s] for [%s]", (Object)value, (Object)pattern);
        String extract = matcher.group(groupName);
        Verify.verify((!matcher.find() ? 1 : 0) != 0, (String)"Match ambiguous in [%s] for [%s]", (Object)value, (Object)pattern);
        return extract;
    }
}

