/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.util.TableLocationUtils;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.Assertions;

public abstract class BaseTestSyncPartitionMetadata
extends ProductTest {
    public void testAddPartition() {
        String tableName = "test_sync_partition_metadata_add_partition";
        this.prepare(tableName);
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'ADD')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT payload, col_x, col_y FROM " + tableName + " ORDER BY 1, 2, 3 ASC", new QueryExecutor.QueryParam[0])).hasMessageMatching(String.format(".*Partition location does not exist: .*%s/col_x=b/col_y=2", this.tableLocation(tableName)));
        BaseTestSyncPartitionMetadata.cleanup(tableName);
    }

    public void testAddPartitionContainingCharactersThatNeedUrlEncoding() {
        String tableName = "test_sync_partition_metadata_add_partition_urlencode";
        String mirrorTableName = "test_sync_partition_metadata_add_partition_urlencode_mirror";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + mirrorTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (payload bigint, col_date varchar, col_time varchar)WITH (format = 'ORC', partitioned_by = ARRAY[ 'col_date', 'col_time' ])", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES (1024, '2022-02-01', '19:00:15'), (1024, '2022-01-17', '20:00:12')", new QueryExecutor.QueryParam[0]);
        String sharedTableLocation = TableLocationUtils.getTableLocation(tableName, 2);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (payload bigint, col_date varchar, col_time varchar)WITH (external_location = '%s', format = 'ORC', partitioned_by = ARRAY[ 'col_date', 'col_time' ])", mirrorTableName, sharedTableLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + mirrorTableName + "', 'ADD')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-02-01", "19:00:15"}));
        BaseTestSyncPartitionMetadata.assertPartitions(mirrorTableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-02-01", "19:00:15"}));
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES (2048, '2022-04-04', '16:59:13')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-02-01", "19:00:15"}), QueryAssert.Row.row((Object[])new Object[]{"2022-04-04", "16:59:13"}));
        BaseTestSyncPartitionMetadata.assertPartitions(mirrorTableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-02-01", "19:00:15"}));
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + mirrorTableName + "', 'ADD')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(mirrorTableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-02-01", "19:00:15"}), QueryAssert.Row.row((Object[])new Object[]{"2022-04-04", "16:59:13"}));
        BaseTestSyncPartitionMetadata.cleanup(mirrorTableName);
        BaseTestSyncPartitionMetadata.cleanup(tableName);
    }

    public void testDropPartition() {
        String tableName = "test_sync_partition_metadata_drop_partition";
        this.prepare(tableName);
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'DROP')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}));
        BaseTestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}));
        BaseTestSyncPartitionMetadata.cleanup(tableName);
    }

    public void testDropPartitionContainingCharactersThatNeedUrlEncoding() {
        String tableName = "test_sync_partition_metadata_drop_partition_urlencode";
        String mirrorTableName = "test_sync_partition_metadata_drop_partition_urlencode_mirror";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + mirrorTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (payload bigint, col_date varchar, col_time varchar)WITH (format = 'ORC', partitioned_by = ARRAY[ 'col_date', 'col_time' ])", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES (1024, '2022-01-17', '20:00:12') , (4096, '2022-01-18', '10:40:16')", new QueryExecutor.QueryParam[0]);
        String sharedTableLocation = TableLocationUtils.getTableLocation(tableName, 2);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (payload bigint, col_date varchar, col_time varchar)WITH (external_location = '%s', format = 'ORC', partitioned_by = ARRAY[ 'col_date', 'col_time' ])", mirrorTableName, sharedTableLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + mirrorTableName + "', 'ADD')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-01-18", "10:40:16"}));
        BaseTestSyncPartitionMetadata.assertPartitions(mirrorTableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-01-18", "10:40:16"}));
        QueryExecutors.onTrino().executeQuery("DELETE FROM " + tableName + " WHERE col_date = '2022-01-17' AND col_time='20:00:12'", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-18", "10:40:16"}));
        BaseTestSyncPartitionMetadata.assertPartitions(mirrorTableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-17", "20:00:12"}), QueryAssert.Row.row((Object[])new Object[]{"2022-01-18", "10:40:16"}));
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + mirrorTableName + "', 'DROP')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(mirrorTableName, QueryAssert.Row.row((Object[])new Object[]{"2022-01-18", "10:40:16"}));
        BaseTestSyncPartitionMetadata.cleanup(mirrorTableName);
        BaseTestSyncPartitionMetadata.cleanup(tableName);
    }

    public void testFullSyncPartition() {
        String tableName = "test_sync_partition_metadata_add_drop_partition";
        this.prepare(tableName);
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'FULL')", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}));
        BaseTestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}), QueryAssert.Row.row((Object[])new Object[]{42, "f", "9"}));
        BaseTestSyncPartitionMetadata.cleanup(tableName);
    }

    public void testInvalidSyncMode() {
        String tableName = "test_repair_invalid_mode";
        this.prepare(tableName);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'INVALID')", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed (.*): Invalid partition metadata sync mode: INVALID");
        BaseTestSyncPartitionMetadata.cleanup(tableName);
    }

    public void testMixedCasePartitionNames() {
        String tableName = "test_sync_partition_mixed_case";
        this.prepare(tableName);
        String tableLocation = this.tableLocation(tableName);
        this.makeHdfsDirectory(String.format("%s/col_x=h/col_Y=11", tableLocation));
        this.copyOrcFileToHdfsDirectory(tableName, String.format("%s/col_x=h/col_Y=11", tableLocation));
        this.makeHdfsDirectory(String.format("%s/COL_X=UPPER/COL_Y=12", tableLocation));
        this.copyOrcFileToHdfsDirectory(tableName, String.format("%s/COL_X=UPPER/COL_Y=12", tableLocation));
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'FULL', false)", new QueryExecutor.QueryParam[0]);
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"UPPER", "12"}), QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}), QueryAssert.Row.row((Object[])new Object[]{"g", "10"}), QueryAssert.Row.row((Object[])new Object[]{"h", "11"}));
        BaseTestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}), QueryAssert.Row.row((Object[])new Object[]{42, "UPPER", "12"}), QueryAssert.Row.row((Object[])new Object[]{42, "f", "9"}), QueryAssert.Row.row((Object[])new Object[]{42, "g", "10"}), QueryAssert.Row.row((Object[])new Object[]{42, "h", "11"}));
    }

    public void testConflictingMixedCasePartitionNames() {
        String tableName = "test_sync_partition_mixed_case";
        String tableLocation = this.tableLocation(tableName);
        this.prepare(tableName);
        this.makeHdfsDirectory(String.format("%s/COL_X=a/cOl_y=1", tableLocation));
        this.copyOrcFileToHdfsDirectory(tableName, String.format("%s/COL_X=a/cOl_y=1", tableLocation));
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'ADD', false)", new QueryExecutor.QueryParam[0])).hasMessageContaining(String.format("One or more partitions already exist for table 'default.%s'", tableName));
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}));
    }

    public void testSyncPartitionMetadataWithNullArgument() {
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata(NULL, 'page_views', 'ADD')", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*schema_name cannot be null.*");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('web', NULl, 'ADD')", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*table_name cannot be null.*");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('web', 'page_views', NULL)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*mode cannot be null.*");
    }

    private String tableLocation(String tableName) {
        return this.schemaLocation() + "/" + tableName;
    }

    protected abstract String schemaLocation();

    private void prepare(String tableName) {
        String tableLocation = this.tableLocation(tableName);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        this.removeHdfsDirectory(tableLocation);
        this.createTable(tableName, tableLocation);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES (1, 'a', '1'), (2, 'b', '2')", new QueryExecutor.QueryParam[0]);
        this.removeHdfsDirectory(String.format("%s/col_x=b/col_y=2", tableLocation));
        this.makeHdfsDirectory(String.format("%s/col_x=f/col_y=9", tableLocation));
        this.copyOrcFileToHdfsDirectory(tableName, String.format("%s/col_x=f/col_y=9", tableLocation));
        this.makeHdfsDirectory(String.format("%s/COL_X=g/col_y=10", tableLocation));
        this.copyOrcFileToHdfsDirectory(tableName, String.format("%s/COL_X=g/col_y=10", tableLocation));
        this.makeHdfsDirectory(String.format("%s/col_x=d", tableLocation));
        this.makeHdfsDirectory(String.format("%s/col_y=3/col_x=h", tableLocation));
        this.makeHdfsDirectory(String.format("%s/col_y=3", tableLocation));
        this.makeHdfsDirectory(String.format("%s/xyz", tableLocation));
        BaseTestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}));
    }

    protected abstract void createTable(String var1, String var2);

    protected abstract void removeHdfsDirectory(String var1);

    protected abstract void makeHdfsDirectory(String var1);

    protected abstract void copyOrcFileToHdfsDirectory(String var1, String var2);

    private static void cleanup(String tableName) {
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    private static void assertPartitions(String tableName, QueryAssert.Row ... rows) {
        QueryResult partitionListResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM \"" + tableName + "$partitions\" ORDER BY 1, 2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).containsExactlyInOrder(rows);
    }

    private static void assertData(String tableName, QueryAssert.Row ... rows) {
        QueryResult dataResult = QueryExecutors.onTrino().executeQuery("SELECT payload, col_x, col_y FROM " + tableName + " ORDER BY 1, 2, 3 ASC", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)dataResult).containsExactlyInOrder(rows);
    }
}

