/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BucketingType {
    NONE{

        @Override
        public String getHiveClustering(String columnName, int buckets) {
            return "";
        }

        @Override
        public List<String> getHiveTableProperties() {
            return ImmutableList.of();
        }

        @Override
        public List<String> getTrinoTableProperties(String columnName, int buckets) {
            return ImmutableList.of();
        }
    }
    ,
    BUCKETED_DEFAULT{

        @Override
        public String getHiveClustering(String columnName, int buckets) {
            return BucketingType.defaultHiveClustering(columnName, buckets);
        }

        @Override
        public List<String> getHiveTableProperties() {
            return ImmutableList.of();
        }

        @Override
        public List<String> getTrinoTableProperties(String columnName, int buckets) {
            return ImmutableList.of((Object)("bucketed_by = ARRAY['" + columnName + "']"), (Object)("bucket_count = " + buckets));
        }
    }
    ,
    BUCKETED_V1{

        @Override
        public String getHiveClustering(String columnName, int buckets) {
            return BucketingType.defaultHiveClustering(columnName, buckets);
        }

        @Override
        public List<String> getHiveTableProperties() {
            return ImmutableList.of((Object)"'bucketing_version'='1'");
        }

        @Override
        public List<String> getTrinoTableProperties(String columnName, int buckets) {
            return ImmutableList.of((Object)"bucketing_version = 1", (Object)("bucketed_by = ARRAY['" + columnName + "']"), (Object)("bucket_count = " + buckets));
        }
    }
    ,
    BUCKETED_V2{

        @Override
        public String getHiveClustering(String columnName, int buckets) {
            return BucketingType.defaultHiveClustering(columnName, buckets);
        }

        @Override
        public List<String> getHiveTableProperties() {
            return ImmutableList.of((Object)"'bucketing_version'='2'");
        }

        @Override
        public List<String> getTrinoTableProperties(String columnName, int buckets) {
            return ImmutableList.of((Object)"bucketing_version = 2", (Object)("bucketed_by = ARRAY['" + columnName + "']"), (Object)("bucket_count = " + buckets));
        }
    };


    public abstract String getHiveClustering(String var1, int var2);

    public abstract List<String> getHiveTableProperties();

    public abstract List<String> getTrinoTableProperties(String var1, int var2);

    private static String defaultHiveClustering(String columnName, int buckets) {
        Objects.requireNonNull(columnName, "columnName is null");
        return String.format("CLUSTERED BY(%s) INTO %s BUCKETS", columnName, buckets);
    }
}

