/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import com.google.inject.Inject;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.hive.TestHiveStorageFormats;
import io.trino.tests.product.utils.JdbcDriverUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveCompatibility
extends HiveProductTest {
    @Inject(optional=true)
    @Named(value="databases.presto.admin_role_enabled")
    private boolean adminRoleEnabled;

    @Test(dataProvider="storageFormatsWithConfiguration", groups={"storage_formats_detailed"})
    public void testInsertAllSupportedDataTypesWithTrino(TestHiveStorageFormats.StorageFormat storageFormat) throws SQLException {
        this.setAdminRole(QueryExecutors.onTrino().getConnection());
        for (Map.Entry<String, String> sessionProperty : storageFormat.getSessionProperties().entrySet()) {
            JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), sessionProperty.getKey(), sessionProperty.getValue());
        }
        String tableName = "storage_formats_compatibility_data_types_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        boolean isAvroStorageFormat = "AVRO".equals(storageFormat.getName());
        ArrayList<HiveCompatibilityColumnData> columnDataList = new ArrayList<HiveCompatibilityColumnData>();
        columnDataList.add(new HiveCompatibilityColumnData("c_boolean", "boolean", "true", true));
        if (!isAvroStorageFormat) {
            columnDataList.add(new HiveCompatibilityColumnData("c_tinyint", "tinyint", "127", 127));
            columnDataList.add(new HiveCompatibilityColumnData("c_smallint", "smallint", "32767", Short.MAX_VALUE));
        }
        columnDataList.add(new HiveCompatibilityColumnData("c_int", "integer", "2147483647", Integer.MAX_VALUE));
        columnDataList.add(new HiveCompatibilityColumnData("c_bigint", "bigint", "9223372036854775807", Long.MAX_VALUE));
        columnDataList.add(new HiveCompatibilityColumnData("c_real", "real", "123.345", 123.345));
        columnDataList.add(new HiveCompatibilityColumnData("c_double", "double", "234.567", 234.567));
        columnDataList.add(new HiveCompatibilityColumnData("c_decimal_10_0", "decimal(10,0)", "346", new BigDecimal("346")));
        columnDataList.add(new HiveCompatibilityColumnData("c_decimal_10_2", "decimal(10,2)", "12345678.91", new BigDecimal("12345678.91")));
        columnDataList.add(new HiveCompatibilityColumnData("c_decimal_38_5", "decimal(38,5)", "1234567890123456789012.34567", new BigDecimal("1234567890123456789012.34567")));
        columnDataList.add(new HiveCompatibilityColumnData("c_char", "char(10)", "'ala ma    '", "ala ma    "));
        columnDataList.add(new HiveCompatibilityColumnData("c_varchar", "varchar(10)", "'ala ma kot'", "ala ma kot"));
        columnDataList.add(new HiveCompatibilityColumnData("c_string", "varchar", "'ala ma kota'", "ala ma kota"));
        columnDataList.add(new HiveCompatibilityColumnData("c_binary", "varbinary", "X'62696e61727920636f6e74656e74'", "binary content".getBytes(StandardCharsets.UTF_8)));
        columnDataList.add(new HiveCompatibilityColumnData("c_date", "date", "DATE '2015-05-10'", Date.valueOf(LocalDate.of(2015, 5, 10))));
        if (isAvroStorageFormat) {
            columnDataList.add(new HiveCompatibilityColumnData("c_timestamp", "timestamp", "TIMESTAMP '2015-05-10 12:15:35.123'", this.isHiveWithBrokenAvroTimestamps() ? Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 6, 30, 35, 123000000)) : Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000))));
        } else {
            columnDataList.add(new HiveCompatibilityColumnData("c_timestamp", "timestamp", "TIMESTAMP '2015-05-10 12:15:35.123'", Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000))));
        }
        columnDataList.add(new HiveCompatibilityColumnData("c_array", "array(integer)", "ARRAY[1, 2, 3]", "[1,2,3]"));
        columnDataList.add(new HiveCompatibilityColumnData("c_map", "map(varchar, varchar)", "MAP(ARRAY['foo'], ARRAY['bar'])", "{\"foo\":\"bar\"}"));
        columnDataList.add(new HiveCompatibilityColumnData("c_row", "row(f1 integer, f2 varchar)", "ROW(42, 'Trino')", "{\"f1\":42,\"f2\":\"Trino\"}"));
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (%s) WITH (%s)", tableName, columnDataList.stream().map(data -> String.format("%s %s", data.columnName, data.trinoColumnType)).collect(Collectors.joining(", ")), storageFormat.getStoragePropertiesAsSql()), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (%s)", tableName, columnDataList.stream().map(data -> data.trinoInsertValue).collect(Collectors.joining(", "))), new QueryExecutor.QueryParam[0]);
        Function<HiveCompatibilityColumnData, Boolean> columnsInterpretedCorrectlyByHiveJdbcDriverPredicate = data -> !ImmutableList.of((Object)"c_array", (Object)"c_map", (Object)"c_row").contains((Object)data.columnName);
        Object[] objectArray = new Object[2];
        objectArray[0] = columnDataList.stream().filter(columnsInterpretedCorrectlyByHiveJdbcDriverPredicate::apply).map(data -> data.columnName).collect(Collectors.joining(", "));
        objectArray[1] = tableName;
        QueryResult queryResult = QueryExecutors.onHive().executeQuery(String.format("SELECT %s FROM %s", objectArray), new QueryExecutor.QueryParam[0]);
        QueryAssert.Row[] rowArray = new QueryAssert.Row[1];
        rowArray[0] = new QueryAssert.Row((List)columnDataList.stream().filter(columnsInterpretedCorrectlyByHiveJdbcDriverPredicate::apply).map(data -> data.hiveJdbcExpectedValue).collect(ImmutableList.toImmutableList()));
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(rowArray);
        queryResult = QueryExecutors.onHive().executeQuery(String.format("SELECT c_array_value FROM %s LATERAL VIEW EXPLODE(c_array) t AS c_array_value", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3})});
        queryResult = QueryExecutors.onHive().executeQuery(String.format("SELECT key, c_map[\"foo\"] AS value FROM %s t LATERAL VIEW EXPLODE(map_keys(t.c_map)) keys AS key", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"foo", "bar"})});
        queryResult = QueryExecutors.onHive().executeQuery(String.format("SELECT c_row.f1, c_row.f2 FROM %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42, "Trino"})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"storage_formats_detailed"})
    public void testTimestampFieldWrittenByOptimizedParquetWriterCanBeReadByHive() throws Exception {
        this.setAdminRole(QueryExecutors.onTrino().getConnection());
        JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.parquet_optimized_writer_enabled", "true");
        String tableName = "parquet_table_timestamp_created_in_trino";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + "(timestamp_precision varchar, a_timestamp timestamp) WITH (format = 'PARQUET')", new QueryExecutor.QueryParam[0]);
        for (HiveTimestampPrecision hiveTimestampPrecision : HiveTimestampPrecision.values()) {
            JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.timestamp_precision", hiveTimestampPrecision.name());
            QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES ('" + hiveTimestampPrecision.name() + "', TIMESTAMP '2021-01-05 12:01:00.111901001')", new QueryExecutor.QueryParam[0]);
            int precisionScalingFactor = (int)Math.pow(10.0, 9 - hiveTimestampPrecision.getPrecision());
            int nanoOfSecond = IntMath.divide((int)111901001, (int)precisionScalingFactor, (RoundingMode)RoundingMode.HALF_UP) * precisionScalingFactor;
            LocalDateTime expectedValue = LocalDateTime.of(2021, 1, 5, 12, 1, 0, nanoOfSecond);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT a_timestamp FROM " + tableName + " WHERE timestamp_precision = '" + hiveTimestampPrecision.name() + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Timestamp.valueOf(expectedValue)})});
            try {
                QueryExecutors.onHive().executeQuery("SET hive.parquet.timestamp.skip.conversion=true", new QueryExecutor.QueryParam[0]);
                QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT a_timestamp FROM " + tableName + " WHERE timestamp_precision = '" + hiveTimestampPrecision.name() + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Timestamp.valueOf(expectedValue)})});
            }
            finally {
                QueryExecutors.onHive().executeQuery("RESET", new QueryExecutor.QueryParam[0]);
            }
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats_detailed"})
    public void testSmallDecimalFieldWrittenByOptimizedParquetWriterCanBeReadByHive() throws Exception {
        this.setAdminRole(QueryExecutors.onTrino().getConnection());
        JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.parquet_optimized_writer_enabled", "true");
        String tableName = "parquet_table_small_decimal_created_in_trino";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " (a_decimal DECIMAL(5,0)) WITH (format='PARQUET')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES (123)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT a_decimal FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("123")})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @DataProvider
    public static TestHiveStorageFormats.StorageFormat[] storageFormatsWithConfiguration() {
        return TestHiveStorageFormats.storageFormatsWithConfiguration();
    }

    private void setAdminRole(Connection connection) {
        if (this.adminRoleEnabled) {
            return;
        }
        try {
            JdbcDriverUtils.setRole(connection, "admin");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static class HiveCompatibilityColumnData {
        private final String columnName;
        private final String trinoColumnType;
        private final String trinoInsertValue;
        private final Object hiveJdbcExpectedValue;

        public HiveCompatibilityColumnData(String columnName, String trinoColumnType, String trinoInsertValue, Object hiveJdbcExpectedValue) {
            this.columnName = columnName;
            this.trinoColumnType = trinoColumnType;
            this.trinoInsertValue = trinoInsertValue;
            this.hiveJdbcExpectedValue = hiveJdbcExpectedValue;
        }
    }
}

