/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestDeltaLakeProceduresCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testUnregisterTable() {
        String tableName = "test_dl_unregister_table" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s WITH (location = 's3://%s/%s') AS SELECT 123 AS col", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{123})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{123})});
            QueryExecutors.onTrino().executeQuery("CALL delta.system.unregister_table('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table '.*' does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching("(?s).*(Table or view not found|The table or view .* cannot be found).*");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

