/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestCreateDropSchema
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;
    @javax.inject.Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @Test
    public void testCreateDropSchema() {
        String schemaName = "test_drop_schema_" + TestingNames.randomNameSuffix();
        String schemaDir = String.format("%s/%s.db", this.warehouseDirectory, schemaName);
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after creating schema");
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.test_drop (col1 int)", schemaName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0])).hasMessageContaining("line 1:1: Cannot drop non-empty schema '%s'", new Object[]{schemaName});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s.test_drop", schemaName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, false, "schema directory exists after dropping schema");
    }

    @Test
    public void testDropSchemaFiles() {
        String schemaName = "schema_without_location_" + TestingNames.randomNameSuffix();
        String schemaDir = String.format("%s/%s.db/", this.warehouseDirectory, schemaName);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s", schemaName), new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after creating schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, false, "schema directory exists after dropping schema");
    }

    @Test
    public void testDropSchemaFilesWithLocation() {
        String schemaName = "schema_with_empty_location_" + TestingNames.randomNameSuffix();
        String schemaDir = this.warehouseDirectory + "/schema-with-empty-location/";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaDir), new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after creating schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, false, "schema directory exists after dropping schema");
    }

    @Test
    public void testDropWithExternalFilesInSubdirectory() {
        String schemaName = "schema_with_nonempty_location_" + TestingNames.randomNameSuffix();
        String schemaDir = this.warehouseDirectory + "/schema-with-nonempty-location/";
        String subDir = schemaDir + "subdir/";
        String externalFile = subDir + "external-file";
        this.hdfsClient.createDirectory(subDir);
        this.hdfsClient.saveFile(externalFile, "");
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaDir), new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalFile, true, "external file exists after creating schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalFile, true, "external file exists after dropping schema");
        this.hdfsClient.delete(schemaDir);
    }

    @Test
    public void testDropSchemaFilesWithEmptyExternalSubdir() {
        String schemaName = "schema_with_empty_subdirectory_" + TestingNames.randomNameSuffix();
        String schemaDir = String.format("%s/%s.db/", this.warehouseDirectory, schemaName);
        String externalSubdir = schemaDir + "external-subdir/";
        this.hdfsClient.createDirectory(externalSubdir);
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalSubdir, true, "external subdirectory exists after creating schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalSubdir, true, "external subdirectory exists after dropping schema");
        this.hdfsClient.delete(schemaDir);
    }

    @Test
    public void testDropSchemaFilesTransactions() {
        String schemaName = "schema_directory_transactions_" + TestingNames.randomNameSuffix();
        String schemaDir = String.format("%s/%s.db/", this.warehouseDirectory, schemaName);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s", schemaName), new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after creating schema");
        QueryExecutors.onTrino().executeQuery("START TRANSACTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("ROLLBACK", new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, true, "schema directory exists after rollback");
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.test_table (i integer)", schemaName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s.test_table", schemaName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("START TRANSACTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("COMMIT", new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(schemaDir, false, "schema directory exists after dropping schema");
    }

    @Test
    public void testDropTransactionsWithExternalFiles() {
        String schemaName = "schema_transactions_with_external_files_" + TestingNames.randomNameSuffix();
        String schemaDir = this.warehouseDirectory + "/schema-transactions-with-external-files/";
        String externalFile = schemaDir + "external-file";
        this.hdfsClient.createDirectory(schemaDir);
        this.hdfsClient.saveFile(externalFile, "");
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s WITH (location = '%s')", schemaName, schemaDir), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("START TRANSACTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("ROLLBACK", new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalFile, true, "external file exists after rolling back drop schema");
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.test_table (i integer)", schemaName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s.test_table", schemaName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("START TRANSACTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("COMMIT", new QueryExecutor.QueryParam[0]);
        this.assertFileExistence(externalFile, true, "schema directory exists after committing drop schema");
    }

    private void assertFileExistence(String path, boolean exists, String description) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.hdfsClient.exist(path)).as("%s (%s)", new Object[]{description, path})).isEqualTo(exists);
    }
}

