/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.jdbc;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.jdbc.TestingRedirectHandlerInjector;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.TpchTableResults;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.tls.HandshakeCertificates;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestExternalAuthorizerOAuth2RefreshToken
extends ProductTest {
    @Inject
    @Named(value="databases.presto.jdbc_url")
    String jdbcUrl;
    @Inject
    @Named(value="databases.presto.https_keystore_path")
    String truststorePath;
    @Inject
    @Named(value="databases.presto.https_keystore_password")
    String truststorePassword;
    private OkHttpClient httpClient;

    @BeforeTestWithContext
    public void setUp() throws Exception {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        KeyStore keyStore = KeyStore.getInstance(new File(this.truststorePath), this.truststorePassword.toCharArray());
        HandshakeCertificates.Builder certificatesBuilder = new HandshakeCertificates.Builder();
        keyStore.aliases().asIterator().forEachRemaining(alias -> {
            try {
                Certificate certificate = keyStore.getCertificate((String)alias);
                if (certificate instanceof X509Certificate) {
                    certificatesBuilder.addTrustedCertificate((X509Certificate)certificate);
                }
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
        HandshakeCertificates certificates = certificatesBuilder.build();
        httpClientBuilder.sslSocketFactory(certificates.sslSocketFactory(), certificates.trustManager());
        httpClientBuilder.followRedirects(true);
        httpClientBuilder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager()));
        this.httpClient = httpClientBuilder.build();
    }

    @Test(groups={"oauth2_refresh", "profile_specific_tests"})
    public void shouldRefreshTokenAfterTokenExpire() throws Exception {
        CountingRedirectHandler redirectHandler = new CountingRedirectHandler();
        TestingRedirectHandlerInjector.setRedirectHandler((Consumer)redirectHandler);
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl);
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM tpch.tiny.nation");
             ResultSet results = statement.executeQuery();){
            QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)results)).matches(TpchTableResults.PRESTO_NATION_RESULT);
            Assertions.assertThat((int)redirectHandler.getRedirectCount()).isEqualTo(1);
            TimeUnit.SECONDS.sleep(10L);
            try (PreparedStatement repeatedStatement = connection.prepareStatement("SELECT * FROM tpch.tiny.nation");
                 ResultSet repeatedResults = repeatedStatement.executeQuery();){
                QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)repeatedResults)).matches(TpchTableResults.PRESTO_NATION_RESULT);
            }
            Assertions.assertThat((int)redirectHandler.getRedirectCount()).isEqualTo(1);
        }
    }

    @Test(groups={"oauth2_refresh", "profile_specific_tests"})
    public void shouldAuthenticateAfterRefreshTokenExpires() throws Exception {
        CountingRedirectHandler redirectHandler = new CountingRedirectHandler();
        TestingRedirectHandlerInjector.setRedirectHandler((Consumer)redirectHandler);
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl);
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM tpch.tiny.nation");
             ResultSet results = statement.executeQuery();){
            QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)results)).matches(TpchTableResults.PRESTO_NATION_RESULT);
            Assertions.assertThat((int)redirectHandler.getRedirectCount()).isEqualTo(1);
            TimeUnit.SECONDS.sleep(20L);
            try (PreparedStatement repeatedStatement = connection.prepareStatement("SELECT * FROM tpch.tiny.nation");
                 ResultSet repeatedResults = repeatedStatement.executeQuery();){
                QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)repeatedResults)).matches(TpchTableResults.PRESTO_NATION_RESULT);
            }
            Assertions.assertThat((int)redirectHandler.getRedirectCount()).isEqualTo(2);
        }
    }

    @Test(groups={"oauth2_refresh", "profile_specific_tests"})
    public void shouldAuthenticateAfterIssuedTokenExpires() throws Exception {
        CountingRedirectHandler redirectHandler = new CountingRedirectHandler();
        TestingRedirectHandlerInjector.setRedirectHandler((Consumer)redirectHandler);
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl);
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM tpch.tiny.nation");
             ResultSet results = statement.executeQuery();){
            QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)results)).matches(TpchTableResults.PRESTO_NATION_RESULT);
            Assertions.assertThat((int)redirectHandler.getRedirectCount()).isEqualTo(1);
            TimeUnit.SECONDS.sleep(35L);
            try (PreparedStatement repeatedStatement = connection.prepareStatement("SELECT * FROM tpch.tiny.nation");
                 ResultSet repeatedResults = repeatedStatement.executeQuery();){
                QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)repeatedResults)).matches(TpchTableResults.PRESTO_NATION_RESULT);
            }
            Assertions.assertThat((int)redirectHandler.getRedirectCount()).isEqualTo(2);
        }
    }

    private class CountingRedirectHandler
    implements Consumer<URI> {
        private final AtomicInteger redirectCount = new AtomicInteger();

        private CountingRedirectHandler() {
        }

        @Override
        public void accept(URI uri) {
            this.redirectCount.incrementAndGet();
            try (Response response = TestExternalAuthorizerOAuth2RefreshToken.this.httpClient.newCall(new Request.Builder().get().url(uri.toString()).build()).execute();){
                int statusCode = response.code();
                Preconditions.checkState((statusCode == 200 ? 1 : 0) != 0, (String)"Invalid status %s", (int)statusCode);
                Objects.requireNonNull(response.body(), "body is null");
                String body = response.body().string();
                Preconditions.checkState((boolean)body.contains("OAuth2 authentication succeeded"), (String)"Invalid response %s", (Object)body);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public int getRedirectCount() {
            return this.redirectCount.get();
        }
    }
}

