/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.utils;

import com.google.common.base.Throwables;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.airlift.log.Logger;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import java.time.temporal.ChronoUnit;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;

public final class HadoopTestUtils {
    private static final Logger log = Logger.get(HiveProductTest.class);
    public static final String RETRYABLE_FAILURES_ISSUES = "https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427";
    @Language(value="RegExp")
    public static final String RETRYABLE_FAILURES_MATCH = "(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)";
    public static final RetryPolicy<QueryResult> ERROR_COMMITTING_WRITE_TO_HIVE_RETRY_POLICY = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(HadoopTestUtils::isErrorCommittingToHive)).withBackoff(1L, 10L, ChronoUnit.SECONDS).withMaxRetries(30).onRetry(event -> log.warn(event.getLastException(), "Query failed on attempt %d, will retry.", new Object[]{event.getAttemptCount()})).build();

    private HadoopTestUtils() {
    }

    private static boolean isErrorCommittingToHive(Throwable throwable) {
        return Pattern.compile(RETRYABLE_FAILURES_MATCH).matcher(Throwables.getStackTraceAsString((Throwable)throwable)).find();
    }
}

