/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.DataProviders;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeColumnMappingMode
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeNone() {
        String tableName = "test_dl_column_mapping_mode_none" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, nested STRUCT<field1: STRING>) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, struct('nested 1'))", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "nested 1"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT a_number, nested.field1 FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_number, nested.field1 FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingMode(String mode) {
        String tableName = "test_dl_column_mapping_mode_name_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>, a_string STRING, part STRING) USING delta  PARTITIONED BY (part) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, array(struct('nested 1')), struct('databricks 1'),'ala', 'part1'), (2, array(struct('nested 2')), struct('databricks 2'), 'kota', 'part2')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "nested 1", "databricks 1", "ala", "part1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "nested 2", "databricks 2", "kota", "part2"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT a_number, array_col[0].array_struct_element, nested.field1, a_string, part FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_number, array_col[1].array_struct_element, nested.field1, a_string, part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_string FROM delta.default." + tableName + " WHERE a_number = 1", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"ala"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_number FROM delta.default." + tableName + " WHERE nested.field1 = 'databricks 1'", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_number FROM delta.default." + tableName + " WHERE part = 'part1'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT a_number FROM default." + tableName + " WHERE part = 'part1'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN a_number TO new_a_column", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN nested.field1 TO field2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN part TO new_part", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"new_a_column", "integer", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", "array(row(array_struct_element varchar))", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", "row(field2 varchar)", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", "varchar", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"new_part", "varchar", "", ""})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT new_a_column, array_col[0].array_struct_element, nested.field2, a_string, new_part FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT new_a_column, array_col[1].array_struct_element, nested.field2, a_string, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeNameWithNonLowerCaseColumn(String mode) {
        String tableName = "test_dl_column_mapping_mode_name_non_loewr_case_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (`mIxEd_CaSe` INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0), (9)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{0}), (Object)QueryAssert.Row.row((Object[])new Object[]{9}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"mixed_case", null, null, 0.0, null, "0", "9"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeCommentOnTable(String mode) {
        String tableName = "test_dl_column_mapping_mode_comment_on_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment by trino'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName), (String)"test comment by trino");
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment by trino");
            QueryExecutors.onDelta().executeQuery("COMMENT ON TABLE default." + tableName + " IS 'test comment by delta'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName), (String)"test comment by delta");
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment by delta");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeCommentOnColumn(String mode) {
        String tableName = "test_dl_column_mapping_mode_comment_on_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (col INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment by trino'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment by trino");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment by trino");
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ALTER COLUMN col COMMENT 'test column comment by delta'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment by delta");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment by delta");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testColumnMappingModeAddColumn(String mode) {
        String tableName = "test_dl_column_mapping_mode_add_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1), (2)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}), (Object)QueryAssert.Row.row((Object[])new Object[]{2}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN another_varchar STRING", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"another_varchar", "varchar", "", ""})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES  (3, 'new column')", new QueryExecutor.QueryParam[0]);
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "new column"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryExecutors.onDelta().executeQuery("REPLACE TABLE default." + tableName + " USING DELTA PARTITIONED BY (another_varchar) AS SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar = 'new column'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3, "new column"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar = 'expect no rows'", new QueryExecutor.QueryParam[0])).hasNoRows();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar <> 'new column'", new QueryExecutor.QueryParam[0])).hasNoRows();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar IS NOT NULL", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3, "new column"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE another_varchar IS NULL", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, null}), QueryAssert.Row.row((Object[])new Object[]{2, null})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testShowStatsFromJsonForColumnMappingMode(String mode) {
        String tableName = "test_dl_show_stats_json_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1), (2), (null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testShowStatsFromParquetForColumnMappingMode(String mode) {
        String tableName = "test_dl_show_parquet_stats_parquet_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testShowStatsOnPartitionedForColumnMappingMode(String mode) {
        String tableName = "test_dl_show_stats_partitioned_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, part STRING) USING delta  PARTITIONED BY (part)  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0, 'a')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'b')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null, null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"part", null, 2.0, 0.33333333333, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "delta-lake-exclude-104", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDropAndAddColumnShowStatsForColumnMappingMode(String mode) {
        String tableName = "test_dl_drop_add_column_show_stats_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, b_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 10), (2, 20), (null, null)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"b_number", null, 2.0, 0.33333333333, null, "10", "20"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " DROP COLUMN b_number", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN b_number INT", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"b_number", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"b_number", 0.0, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testProjectionPushdownDmlWithColumnMappingMode(String mode) {
        String sourceTableName = "test_projection_pushdown_source_column_mapping_mode_" + TestingNames.randomNameSuffix();
        String targetTableName = "test_projection_pushdown_target_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + targetTableName + " (nation STRUCT<key INT, name STRING>, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + targetTableName + "'TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + sourceTableName + "  (nation STRUCT<key INT, name STRING>, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + sourceTableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (struct(1, 'nation1'), 100), (struct(2, 'nation2'), 200), (struct(3, 'nation3'), 300), (struct(4, 'nation4'), 400)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + sourceTableName + " VALUES (struct(1000, 'nation1000'), 1000), (struct(2, 'nation2'), 20000), (struct(3000, 'nation3000'), 3000), (struct(4, 'nation4'), 40000)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("MERGE INTO default." + targetTableName + " target USING default." + sourceTableName + " source ON (target.nation.key = source.nation.key) WHEN MATCHED AND source.nation.name = 'nation4' THEN DELETE WHEN MATCHED THEN UPDATE SET nation.key = (target.nation.key + source.nation.key + source.regionkey) WHEN NOT MATCHED THEN INSERT (nation, regionkey) VALUES (source.nation, source.regionkey)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT nation.key, nation.name, regionkey FROM " + targetTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000, "nation1000", 1000}), QueryAssert.Row.row((Object[])new Object[]{3000, "nation3000", 3000}), QueryAssert.Row.row((Object[])new Object[]{1, "nation1", 100}), QueryAssert.Row.row((Object[])new Object[]{3, "nation3", 300}), QueryAssert.Row.row((Object[])new Object[]{20004, "nation2", 200})});
            QueryExecutors.onDelta().executeQuery("DELETE FROM " + targetTableName + " WHERE regionkey = 100", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("UPDATE " + targetTableName + " SET nation.name = 'nation20004' WHERE regionkey = 200", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT nation.key, nation.name, regionkey FROM " + targetTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000, "nation1000", 1000}), QueryAssert.Row.row((Object[])new Object[]{3000, "nation3000", 3000}), QueryAssert.Row.row((Object[])new Object[]{3, "nation3", 300}), QueryAssert.Row.row((Object[])new Object[]{20004, "nation20004", 200})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + targetTableName);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + sourceTableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "delta-lake-exclude-104", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testChangeColumnMappingAndShowStatsForColumnMappingMode() {
        String tableName = "test_dl_change_column_mapping_and_show_stats_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, b_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='none', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 10), (2, 20), (null, null)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"b_number", null, 2.0, 0.33333333333, null, "10", "20"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES('delta.columnMapping.mode'='name')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " DROP COLUMN b_number", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN b_number INT", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"b_number", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"b_number", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="changeColumnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testChangeColumnMappingMode(String sourceMappingMode, String targetMappingMode, boolean supported) {
        String tableName = "test_dl_change_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + sourceMappingMode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            if (supported) {
                QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES('delta.columnMapping.mode'='" + targetMappingMode + "')", new QueryExecutor.QueryParam[0]);
            } else {
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES('delta.columnMapping.mode'='" + targetMappingMode + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Changing column mapping mode from '%s' to '%s' is not supported".formatted(sourceMappingMode, targetMappingMode));
            }
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @DataProvider
    public Object[][] changeColumnMappingDataProvider() {
        return new Object[][]{{"none", "id", false}, {"none", "name", true}, {"id", "none", false}, {"id", "name", false}, {"name", "none", false}, {"name", "id", false}};
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testUnsupportedOperationsColumnMappingMode(String mode) {
        String tableName = "test_dl_unsupported_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, a_string STRING) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            if (!mode.equals("id")) {
                QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 'one'), (2, 'two')", new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(2);
                QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(2);
                QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a_string = 'test'", new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(0);
            } else {
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 'one'), (2, 'two')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing with column mapping id is not supported");
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing with column mapping id is not supported");
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a_string = 'test'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing with column mapping id is not supported");
            }
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " EXECUTE OPTIMIZE", new QueryExecutor.QueryParam[0])).hasMessageContaining("Executing 'optimize' procedure with column mapping %s is not supported".formatted(mode));
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col varchar", new QueryExecutor.QueryParam[0])).hasMessageContaining("Adding a column with column mapping %s is not supported".formatted(mode));
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME COLUMN a_number TO renamed_column", new QueryExecutor.QueryParam[0])).hasMessageContaining("This connector does not support renaming columns");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " DROP COLUMN a_number", new QueryExecutor.QueryParam[0])).hasMessageContaining("This connector does not support dropping columns");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testSpecialCharacterColumnNamesWithColumnMappingMode(String mode) {
        String tableName = "test_dl_special_character_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (`;{}()\\n\\t=` INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{";{}()\\n\\t=", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingWithTrueAndFalseDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testSupportedNonPartitionedColumnMappingWrites(String mode, boolean statsAsJsonEnabled) {
        String tableName = "test_dl_dml_column_mapping_mode_" + mode + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, a_string STRING, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.checkpointInterval' = 1,  'delta.checkpoint.writeStatsAsJson' = " + statsAsJsonEnabled + ",  'delta.checkpoint.writeStatsAsStruct' = " + !statsAsJsonEnabled + ",  'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            String trinoColumns = "a_number, a_string, array_col[1].array_struct_element, nested.field1";
            String deltaColumns = "a_number, a_string, array_col[0].array_struct_element, nested.field1";
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 'first value', ARRAY[ROW('nested 1')], ROW('databricks 1')),        (2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2')),        (3, 'third value', ARRAY[ROW('nested 3')], ROW('databricks 3')),        (4, 'four', ARRAY[ROW('nested 4')], ROW('databricks 4'))", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(tableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "third value", "nested 3", "databricks 3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "nested 4", "databricks 4"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 4.0, 0.0, null, "1", "4"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", 29.0, 4.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 4.0, null, null})));
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a_number = a_number + 10 WHERE a_number in (3, 4)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("UPDATE default." + tableName + " SET a_number = a_number + 20 WHERE a_number in (1, 2)", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(tableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{21, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{22, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{13, "third value", "nested 3", "databricks 3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{14, "four", "nested 4", "databricks 4"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 4.0, 0.0, null, "13", "22"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", 29.0, 4.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 4.0, null, null})));
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a_number = 22", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a_number = 13", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a_number = 21", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(tableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{14, "four", "nested 4", "databricks 4"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 1.0, 0.0, null, "14", "14"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", 29.0, 1.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingWithTrueAndFalseDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testSupportedPartitionedColumnMappingWrites(String mode, boolean statsAsJsonEnabled) {
        String tableName = "test_dl_dml_column_mapping_mode_" + mode + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, a_string STRING, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>) USING delta  PARTITIONED BY (a_string) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.checkpointInterval' = 1,  'delta.checkpoint.writeStatsAsJson' = " + statsAsJsonEnabled + ",  'delta.checkpoint.writeStatsAsStruct' = " + !statsAsJsonEnabled + ",  'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            String trinoColumns = "a_number, a_string, array_col[1].array_struct_element, nested.field1";
            String deltaColumns = "a_number, a_string, array_col[0].array_struct_element, nested.field1";
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 'first value', ARRAY[ROW('nested 1')], ROW('databricks 1')),        (2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2')),        (3, 'third value', ARRAY[ROW('nested 3')], ROW('databricks 3')),        (4, 'four', ARRAY[ROW('nested 4')], ROW('databricks 4'))", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(tableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "third value", "nested 3", "databricks 3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "nested 4", "databricks 4"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 4.0, 0.0, null, "1", "4"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", null, 4.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 4.0, null, null})));
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a_number = a_number + 10 WHERE a_number in (3, 4)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("UPDATE default." + tableName + " SET a_number = a_number + 20 WHERE a_number in (1, 2)", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(tableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{21, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{22, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{13, "third value", "nested 3", "databricks 3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{14, "four", "nested 4", "databricks 4"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 4.0, 0.0, null, "13", "22"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", null, 4.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 4.0, null, null})));
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a_number = 22", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a_number = 13", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a_number = 21", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(tableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{14, "four", "nested 4", "databricks 4"})));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 1.0, 0.0, null, "14", "14"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", null, 1.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="supportedColumnMappingForDmlDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testMergeUpdateWithColumnMapping(String mode) {
        String sourceTableName = "test_merge_update_source_column_mapping_mode_" + TestingNames.randomNameSuffix();
        String targetTableName = "test_merge_update_target_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + targetTableName + " (nationkey INT, name STRING, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + targetTableName + "'TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + sourceTableName + " (nationkey INT, name STRING, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + sourceTableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (1, 'nation1', 100), (2, 'nation2', 200), (3, 'nation3', 300)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + sourceTableName + " VALUES (1000, 'nation1000', 1000), (2, 'nation2', 20000), (3000, 'nation3000', 3000)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + targetTableName + " target USING delta.default." + sourceTableName + " source ON (target.nationkey = source.nationkey) WHEN MATCHED THEN UPDATE SET nationkey = (target.nationkey + source.nationkey + source.regionkey) WHEN NOT MATCHED THEN INSERT (nationkey, name, regionkey) VALUES (source.nationkey, source.name, source.regionkey)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + targetTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000, "nation1000", 1000}), QueryAssert.Row.row((Object[])new Object[]{3000, "nation3000", 3000}), QueryAssert.Row.row((Object[])new Object[]{1, "nation1", 100}), QueryAssert.Row.row((Object[])new Object[]{3, "nation3", 300}), QueryAssert.Row.row((Object[])new Object[]{20004, "nation2", 200})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + targetTableName);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + sourceTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="supportedColumnMappingForDmlDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testMergeDeleteWithColumnMapping(String mode) {
        String sourceTableName = "test_dl_merge_delete_source_column_mapping_mode_" + mode + TestingNames.randomNameSuffix();
        String targetTableName = "test_dl_merge_delete_target_column_mapping_mode_" + mode + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + sourceTableName + " (a_number INT, a_string STRING, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>) USING delta  PARTITIONED BY (a_string) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + sourceTableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' ='" + mode + "')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + targetTableName + " (a_number INT, a_string STRING, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>) USING delta  PARTITIONED BY (a_string) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + targetTableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' ='" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + sourceTableName + " VALUES (1, 'first value', ARRAY[ROW('nested 1')], ROW('databricks 1')),        (2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2')),        (3, 'third value', ARRAY[ROW('nested 3')], ROW('databricks 3')),        (4, 'four', ARRAY[ROW('nested 4')], ROW('databricks 4'))", new QueryExecutor.QueryParam[0]);
            String trinoColumns = "a_number, a_string, array_col[1].array_struct_element, nested.field1";
            String deltaColumns = "a_number, a_string, array_col[0].array_struct_element, nested.field1";
            this.assertDeltaTrinoTableEquals(sourceTableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "third value", "nested 3", "databricks 3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "nested 4", "databricks 4"})));
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + targetTableName + " VALUES (1000, '1000 value', ARRAY[ROW('nested 1000')], ROW('databricks 1000')),        (2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2'))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (3000, '3000 value', array(struct('nested 3000')), struct('databricks 3000')),        (4, 'four', array(struct('nested 4')), struct('databricks 4'))", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(targetTableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1000, "1000 value", "nested 1000", "databricks 1000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3000, "3000 value", "nested 3000", "databricks 3000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "nested 4", "databricks 4"})));
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + targetTableName + " t USING delta.default." + sourceTableName + " s ON (t.a_number = s.a_number) WHEN MATCHED THEN DELETE WHEN NOT MATCHED THEN INSERT (a_number, a_string, array_col, nested) VALUES (s.a_number, s.a_string, s.array_col, s.nested)", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(targetTableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1000, "1000 value", "nested 1000", "databricks 1000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3000, "3000 value", "nested 3000", "databricks 3000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "third value", "nested 3", "databricks 3"})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + sourceTableName);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + targetTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testUnsupportedColumnMappingModeChangeDataFeed(String mode) {
        String sourceTableName = "test_dl_cdf_target_column_mapping_mode_" + TestingNames.randomNameSuffix();
        String targetTableName = "test_dl_cdf_source_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + targetTableName + " (nationkey INT, name STRING, regionkey INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + targetTableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.enableChangeDataFeed' = true)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + sourceTableName + " (nationkey INT, name STRING, regionkey INT)  USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + sourceTableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (1, 'nation1', 100)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (2, 'nation2', 200)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (3, 'nation3', 300)", new QueryExecutor.QueryParam[0]);
            if (mode.equals("id")) {
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + targetTableName + " SET regionkey = 10", new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported column mapping mode for tables with change data feed enabled: id");
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + targetTableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported column mapping mode for tables with change data feed enabled: id");
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + targetTableName + " cdf USING delta.default." + sourceTableName + " n ON (cdf.nationkey = n.nationkey) WHEN MATCHED THEN UPDATE SET nationkey = (cdf.nationkey + n.nationkey + n.regionkey) WHEN NOT MATCHED THEN INSERT (nationkey, name, regionkey) VALUES (n.nationkey, n.name, n.regionkey)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported column mapping mode for tables with change data feed enabled: id");
            } else if (mode.equals("name")) {
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + targetTableName + " SET regionkey = 10", new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported column mapping mode for tables with change data feed enabled: " + mode);
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + targetTableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported column mapping mode for tables with change data feed enabled: " + mode);
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + targetTableName + " cdf USING delta.default." + sourceTableName + " n ON (cdf.nationkey = n.nationkey) WHEN MATCHED THEN UPDATE SET nationkey = (cdf.nationkey + n.nationkey + n.regionkey) WHEN NOT MATCHED THEN INSERT (nationkey, name, regionkey) VALUES (n.nationkey, n.name, n.regionkey)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported column mapping mode for tables with change data feed enabled: " + mode);
            }
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT nationkey, name, regionkey, _change_type, _commit_version FROM table_changes('default." + targetTableName + "', 0)", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "nation1", 100, "insert", 1}), QueryAssert.Row.row((Object[])new Object[]{2, "nation2", 200, "insert", 2}), QueryAssert.Row.row((Object[])new Object[]{3, "nation3", 300, "insert", 3})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + targetTableName);
        }
    }

    private void assertDeltaTrinoTableEquals(String tableName, String trinoQuery, String deltaQuery, List<QueryAssert.Row> expectedRows) {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT " + deltaQuery + " FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT " + trinoQuery + " FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
    }

    @DataProvider
    public Object[][] columnMappingWithTrueAndFalseDataProvider() {
        return DataProviders.cartesianProduct((Object[][][])new Object[][][]{this.supportedColumnMappingForDmlDataProvider(), DataProviders.trueFalse()});
    }

    @DataProvider
    public Object[][] columnMappingDataProvider() {
        return new Object[][]{{"id"}, {"name"}};
    }

    @DataProvider
    public Object[][] supportedColumnMappingForDmlDataProvider() {
        return new Object[][]{{"none"}, {"name"}};
    }
}

