/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksDelete
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDeleteOnAppendOnlyTableFails() {
        String tableName = "test_delete_on_append_only_table_fails_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a INT, b INT)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'          TBLPROPERTIES ('delta.appendOnly' = true)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2, 12)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("This table is configured to only allow appends");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot modify rows from a table with 'delta.appendOnly' set to true");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 12})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-73", "delta-lake-exclude-91", "delta-lake-exclude-104", "delta-lake-exclude-113", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDeletionVectors() {
        String tableName = "test_deletion_vectors_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a INT, b INT)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'          TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2, 22)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM delta.default", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT comment FROM information_schema.columns WHERE table_schema = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0])).hasNoRows();
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default.\"" + tableName + "$history\"", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (3, 33)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a = 3", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.a = s.a) WHEN MATCHED THEN UPDATE SET b = -1", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* does not exist");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

