/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.net.URI;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeltaLakeSelectCompatibility
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testPartitionedSelectSpecialCharacters() {
        String tableName = "test_dl_partitioned_select_special" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a_number INT, a_string STRING)         USING delta          PARTITIONED BY (a_string)         LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'spark=equal'), (2, 'spark+plus'), (3, 'spark space'),(4, 'spark:colon'),(5, 'spark%percent')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (10, 'trino=equal'), (20, 'trino+plus'), (30, 'trino space'),(40, 'trino:colon'),(50, 'trino%percent')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "spark=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "spark+plus"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "spark space"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "spark:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "spark%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "trino=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{20, "trino+plus"}), (Object)QueryAssert.Row.row((Object[])new Object[]{30, "trino space"}), (Object)QueryAssert.Row.row((Object[])new Object[]{40, "trino:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{50, "trino%percent"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            String deltaFilePath = (String)QueryExecutors.onDelta().executeQuery("SELECT input_file_name() FROM default." + tableName + " WHERE a_number = 1", new QueryExecutor.QueryParam[0]).getOnlyValue();
            String trinoFilePath = (String)QueryExecutors.onTrino().executeQuery("SELECT \"$path\" FROM delta.default." + tableName + " WHERE a_number = 1", new QueryExecutor.QueryParam[0]).getOnlyValue();
            Assert.assertNotEquals((Object)deltaFilePath, (Object)trinoFilePath);
            Assert.assertEquals((String)String.format("s3://%s%s", this.bucketName, URI.create(deltaFilePath).getPath()), (String)trinoFilePath);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " WHERE \"$path\" = '" + trinoFilePath + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "spark=equal"})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

