/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.S3ClientFactory;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeTransactionLogCache
extends BaseTestDeltaLakeS3Storage {
    @Inject
    @Named(value="s3.server_type")
    private String s3ServerType;
    private AmazonS3 s3;

    @BeforeTestWithContext
    public void setup() {
        super.setUp();
        this.s3 = new S3ClientFactory().createS3Client(this.s3ServerType);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testAllDataFilesAreLoadedWhenTransactionLogFileAfterTheCachedTableVersionIsMissing() {
        String tableName = "test_dl_cached_table_files_accuracy_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s', checkpoint_interval = 10)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES 1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName, new QueryExecutor.QueryParam[0]);
        IntStream.range(2, 13).forEach(v -> QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES " + v, new QueryExecutor.QueryParam[0]));
        List<QueryAssert.Row> expectedRows = List.of(QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4}), QueryAssert.Row.row((Object[])new Object[]{5}), QueryAssert.Row.row((Object[])new Object[]{6}), QueryAssert.Row.row((Object[])new Object[]{7}), QueryAssert.Row.row((Object[])new Object[]{8}), QueryAssert.Row.row((Object[])new Object[]{9}), QueryAssert.Row.row((Object[])new Object[]{10}), QueryAssert.Row.row((Object[])new Object[]{11}), QueryAssert.Row.row((Object[])new Object[]{12}));
        Object[] transactionLogFilesToRemove = new String[]{tableDirectory + "/_delta_log/00000000000000000000.json", tableDirectory + "/_delta_log/00000000000000000001.json", tableDirectory + "/_delta_log/00000000000000000002.json", tableDirectory + "/_delta_log/00000000000000000003.json", tableDirectory + "/_delta_log/00000000000000000004.json", tableDirectory + "/_delta_log/00000000000000000005.json"};
        DeleteObjectsResult deleteObjectsResult = this.s3.deleteObjects(new DeleteObjectsRequest(this.bucketName).withKeys((String[])transactionLogFilesToRemove));
        Assertions.assertThat(deleteObjectsResult.getDeletedObjects().stream().map(DeleteObjectsResult.DeletedObject::getKey).collect(Collectors.toList())).containsExactlyInAnyOrder(transactionLogFilesToRemove);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(expectedRows);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }
}

