/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.JDBCType;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestIcebergRedirectionToHive
extends ProductTest {
    @BeforeTestWithContext
    public void createAdditionalSchema() {
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS iceberg.nondefaultschema", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirect() {
        String tableName = "redirect_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectWithNonDefaultSchema() {
        String tableName = "redirect_non_default_schema_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.nondefaultschema." + tableName;
        String icebergTableName = "iceberg.nondefaultschema." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectToNonexistentCatalog() {
        String tableName = "redirect_to_nonexistent_hive_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("SET SESSION iceberg.hive_catalog_name = 'someweirdcatalog'", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'iceberg.default.redirect_to_nonexistent_hive_.*' redirected to 'someweirdcatalog.default.redirect_to_nonexistent_hive_.*', but the target catalog 'someweirdcatalog' does not exist");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectWithDefaultSchemaInSession() {
        String tableName = "redirect_with_use_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + tableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("USE hive.default", new QueryExecutor.QueryParam[0]);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + tableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectPartitionsToUnpartitioned() {
        String tableName = "hive_unpartitioned_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE iceberg.default.\"" + tableName + "$partitions\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): Table '" + icebergTableName + "$partitions' redirected to '" + hiveTableName + "$partitions', but the target table '" + hiveTableName + "$partitions' does not exist");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectInvalidSystemTable() {
        String tableName = "hive_invalid_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE iceberg.default.\"" + tableName + "$invalid\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): Table '" + icebergTableName + "$invalid' redirected to '" + hiveTableName + "$invalid', but the target table '" + hiveTableName + "$invalid' does not exist");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectPartitionsToPartitioned() {
        String tableName = "hive_partitioned_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, true);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("TABLE iceberg.default.\"" + tableName + "$partitions\"", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"}, dataProvider="schemaAndPartitioning")
    public void testInsert(String schema, boolean partitioned) {
        String tableName = "hive_insert_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive." + schema + "." + tableName;
        String icebergTableName = "iceberg." + schema + "." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, partitioned, false);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + icebergTableName + " VALUES (42, 'some name', 'some comment', 12)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42L, "some name", "some comment", 12L})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42L, "some name", "some comment", 12L})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @DataProvider
    public static Object[][] schemaAndPartitioning() {
        return new Object[][]{{"default", false}, {"default", true}, {"nondefaultschema", false}, {"nondefaultschema", true}};
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDelete() {
        String tableName = "hive_delete_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, true);
        QueryExecutors.onTrino().executeQuery("DELETE FROM " + icebergTableName + " WHERE regionkey = 1", new QueryExecutor.QueryParam[0]);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT nationkey, name, comment, regionkey FROM tpch.tiny.nation WHERE regionkey != 1", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testUpdate() {
        String tableName = "hive_update_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, true);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE " + icebergTableName + " SET nationkey = nationkey + 100 WHERE regionkey = 1", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): Modifying Hive table rows is only supported for transactional tables");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDropTable() {
        String tableName = "iceberg_drop_hive_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table '" + hiveTableName + "' does not exist");
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDescribe() {
        String tableName = "hive_describe_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, true);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("DESCRIBE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("DESCRIBE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testShowCreateTable() {
        String tableName = "hive_show_create_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, true);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + icebergTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CREATE TABLE " + hiveTableName + " (\n   nationkey bigint,\n   name varchar(25),\n   comment varchar(152),\n   regionkey bigint\n)\nWITH (\n   format = 'ORC',\n   partitioned_by = ARRAY['regionkey']\n)"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testShowStats() {
        String tableName = "hive_show_create_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, true);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR " + icebergTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"nationkey", null, 5.0, 0.0, null, "0", "24"}), QueryAssert.Row.row((Object[])new Object[]{"name", 177.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"comment", 1857.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"regionkey", null, 5.0, 0.0, null, "0", "4"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 25.0, null, null})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableRename() {
        String tableName = "iceberg_rename_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE " + icebergTableName + " RENAME TO iceberg.default." + tableName + "_new", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table rename across catalogs is not supported");
        String newTableNameWithoutCatalogWithoutSchema = tableName + "_new_without_catalog_without_schema";
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + icebergTableName + " RENAME TO " + newTableNameWithoutCatalogWithoutSchema, new QueryExecutor.QueryParam[0]);
        String newTableNameWithoutCatalogWithSchema = tableName + "_new_without_catalog_with_schema";
        QueryExecutors.onTrino().executeQuery("ALTER TABLE iceberg.default." + newTableNameWithoutCatalogWithoutSchema + " RENAME TO default." + newTableNameWithoutCatalogWithSchema, new QueryExecutor.QueryParam[0]);
        String newTableNameWithCatalogWithSchema = tableName + "_new_with_catalog_with_schema";
        QueryExecutors.onTrino().executeQuery("ALTER TABLE iceberg.default." + newTableNameWithoutCatalogWithSchema + " RENAME TO hive.default." + newTableNameWithCatalogWithSchema, new QueryExecutor.QueryParam[0]);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName + "_new_with_catalog_with_schema", new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName + "_new_with_catalog_with_schema", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName + "_new_with_catalog_with_schema", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableAddColumn() {
        String tableName = "hive_alter_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + icebergTableName + " ADD COLUMN some_new_column double", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("DESCRIBE " + hiveTableName, new QueryExecutor.QueryParam[0]).column(1)).containsOnly(new Object[]{"nationkey", "name", "regionkey", "comment", "some_new_column"});
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT nationkey, name, comment, regionkey, NULL FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableRenameColumn() {
        String tableName = "hive_rename_column_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + icebergTableName + " RENAME COLUMN nationkey TO nation_key", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("DESCRIBE " + icebergTableName, new QueryExecutor.QueryParam[0]).column(1)).containsOnly(new Object[]{"nation_key", "name", "regionkey", "comment"});
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT nationkey as nation_key, name, comment, regionkey FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableDropColumn() {
        String tableName = "hive_alter_table_drop_column_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + icebergTableName + " DROP COLUMN comment", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("DESCRIBE " + icebergTableName, new QueryExecutor.QueryParam[0]).column(1)).containsOnly(new Object[]{"nationkey", "name", "regionkey"});
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.orc_use_column_names = true", new QueryExecutor.QueryParam[0]);
        TestIcebergRedirectionToHive.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT nationkey, name, regionkey FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testCommentTable() {
        String tableName = "hive_comment_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        TestIcebergRedirectionToHive.assertTableComment("hive", "default", tableName).isNull();
        TestIcebergRedirectionToHive.assertTableComment("iceberg", "default", tableName).isNull();
        String tableComment = "This is my table, there are many like it but this one is mine";
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE " + icebergTableName + " IS '%s'", tableComment), new QueryExecutor.QueryParam[0]);
        TestIcebergRedirectionToHive.assertTableComment("hive", "default", tableName).isEqualTo(tableComment);
        TestIcebergRedirectionToHive.assertTableComment("iceberg", "default", tableName).isEqualTo(tableComment);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testShowGrants() {
        String tableName = "hive_show_grants_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, true);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SHOW GRANTS ON %s", icebergTableName), new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + icebergTableName + " is redirected to " + hiveTableName + " and SHOW GRANTS is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testInformationSchemaColumns() {
        String schemaName = "redirect_information_schema_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_information_schema_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive." + schemaName + "." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM iceberg.information_schema.columns WHERE table_schema = '%s' AND table_name='%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "name", 2, null, "YES", "varchar(25)"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "comment", 3, null, "YES", "varchar(152)"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "regionkey", 4, null, "YES", "bigint"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM iceberg.information_schema.columns WHERE table_schema = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "name", 2, null, "YES", "varchar(25)"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "comment", 3, null, "YES", "varchar(152)"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "regionkey", 4, null, "YES", "bigint"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.information_schema.columns WHERE table_schema = '%s' AND table_name='%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name", 2, null, "YES", "varchar(25)"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment", 3, null, "YES", "varchar(152)"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey", 4, null, "YES", "bigint"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA hive." + schemaName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testSystemJdbcColumns() {
        String schemaName = "redirect_system_jdbc_columns_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_system_jdbc_columns_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive." + schemaName + "." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'iceberg' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "comment"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "regionkey"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'iceberg' AND table_schem = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "comment"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "regionkey"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA hive." + schemaName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testGrant() {
        String tableName = "hive_grant" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("GRANT SELECT ON " + icebergTableName + " TO ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + icebergTableName + " is redirected to " + hiveTableName + " and GRANT is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRevoke() {
        String tableName = "hive_revoke" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("REVOKE SELECT ON " + icebergTableName + " FROM ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + icebergTableName + " is redirected to " + hiveTableName + " and REVOKE is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testSetTableAuthorization() {
        String tableName = "hive_revoke" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE " + icebergTableName + " SET AUTHORIZATION ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + icebergTableName + " is redirected to " + hiveTableName + " and SET TABLE AUTHORIZATION is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDeny() {
        String tableName = "hive_deny" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestIcebergRedirectionToHive.createHiveTable(hiveTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DENY DELETE ON " + icebergTableName + " TO ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + icebergTableName + " is redirected to " + hiveTableName + " and DENY is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    private static void createHiveTable(String tableName, boolean partitioned) {
        TestIcebergRedirectionToHive.createHiveTable(tableName, partitioned, true);
    }

    private static void createHiveTable(String tableName, boolean partitioned, boolean withData) {
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " " + (partitioned ? "WITH (partitioned_by = ARRAY['regionkey']) " : "") + " AS SELECT nationkey, name, comment, regionkey FROM tpch.tiny.nation " + (withData ? "WITH DATA" : "WITH NO DATA"), new QueryExecutor.QueryParam[0]);
    }

    private static AbstractStringAssert<?> assertTableComment(String catalog, String schema, String tableName) {
        return Assertions.assertThat((String)((String)TestIcebergRedirectionToHive.readTableComment(catalog, schema, tableName).getOnlyValue()));
    }

    private static QueryResult readTableComment(String catalog, String schema, String tableName) {
        return QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = ? AND schema_name = ? AND table_name = ?", new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)catalog), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)schema), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)tableName)});
    }

    private static void assertResultsEqual(QueryResult first, QueryResult second) {
        QueryAssert.assertThat((QueryResult)first).containsOnly((List)second.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        QueryAssert.assertThat((QueryResult)second).containsOnly((List)first.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
    }
}

