/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.Iterables;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DatabricksVersion;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeltaLakeAlterTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testAddColumnWithCommentOnTrino() {
        String tableName = "test_dl_add_column_with_comment_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT COMMENT 'new column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "new_col"), (String)"new column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "new_col"), (String)"new column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testAddColumnUnsupportedWriterVersion() {
        String tableName = "test_dl_add_column_unsupported_writer_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='6')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col int", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 6 which is not supported");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testRenameColumn() {
        String tableName = "test_dl_rename_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT) USING DELTA LOCATION 's3://%s/%s' TBLPROPERTIES ('delta.columnMapping.mode'='name')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN col TO new_col", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT new_col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT new_col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testRenamePartitionedColumn() {
        String tableName = "test_dl_rename_partitioned_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT, part STRING) USING DELTA LOCATION 's3://%s/%s' PARTITIONED BY (part) TBLPROPERTIES ('delta.columnMapping.mode'='name')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'part1')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col, part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN part TO new_part", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2, 'part2')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT col, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"}), QueryAssert.Row.row((Object[])new Object[]{2, "part2"})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCommentOnTable() {
        String tableName = "test_dl_comment_table_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName), (String)"test comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCommentOnTableUnsupportedWriterVersion() {
        String tableName = "test_dl_comment_table_unsupported_writer_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='6')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 6 which is not supported");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCommentOnColumn() {
        String tableName = "test_dl_comment_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCommentOnColumnUnsupportedWriterVersion() {
        String tableName = "test_dl_comment_column_unsupported_writer_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='6')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 6 which is not supported");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "delta-lake-exclude-91", "delta-lake-exclude-104", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testOptimizeUnsupportedWriterVersion() {
        String tableName = "test_dl_optimize_unsupported_writer_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='6')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " EXECUTE OPTIMIZE", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 6 which is not supported");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoAlterTablePreservesTableMetadata() {
        String tableName = "test_trino_alter_table_preserves_table_metadata_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.appendOnly' = true)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_column INT", new QueryExecutor.QueryParam[0]);
            List properties = (List)Iterables.getOnlyElement((Iterable)QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES " + tableName + "(delta.appendOnly)", new QueryExecutor.QueryParam[0]).rows());
            Assert.assertTrue((boolean)Boolean.parseBoolean((String)properties.get(1)));
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoAlterTablePreservesChangeDataFeed() {
        String tableName = "test_trino_alter_table_preserves_cdf_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int)\nUSING DELTA LOCATION 's3://%s/%s'\nTBLPROPERTIES ('delta.enableChangeDataFeed' = true)\n", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_column INT", new QueryExecutor.QueryParam[0]);
            Object enableChangeDataFeed = Iterables.getOnlyElement((Iterable)QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES " + tableName + "(delta.enableChangeDataFeed)", new QueryExecutor.QueryParam[0]).column(2));
            Assert.assertEquals((Object)enableChangeDataFeed, (Object)"true");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-73", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoPreservesReaderAndWriterVersions() {
        String tableName = "test_trino_preserves_versions_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minReaderVersion'='1', 'delta.minWriterVersion'='1', 'delta.checkpointInterval' = 1)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET col = 2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.col = s.col) WHEN MATCHED THEN UPDATE SET new_col = 3", new QueryExecutor.QueryParam[0]);
            List minReaderVersion = (List)Iterables.getOnlyElement((Iterable)QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES " + tableName + "(delta.minReaderVersion)", new QueryExecutor.QueryParam[0]).rows());
            Assert.assertEquals((String)((String)minReaderVersion.get(1)), (String)"1");
            List minWriterVersion = (List)Iterables.getOnlyElement((Iterable)QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES " + tableName + "(delta.minWriterVersion)", new QueryExecutor.QueryParam[0]).rows());
            Assert.assertEquals((String)((String)minWriterVersion.get(1)), (String)"1");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoAlterTablePreservesGeneratedColumn() {
        String tableName = "test_trino_alter_table_preserves_generated_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (a INT, b INT GENERATED ALWAYS AS (a * 2))\nUSING DELTA LOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".b IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN c INT", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{(DeltaLakeTestUtils.getDatabricksRuntimeVersion().orElseThrow().equals(DatabricksVersion.DATABRICKS_91_RUNTIME_VERSION) ? "`b`" : "b") + " INT GENERATED ALWAYS AS ( a * 2 )"});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (a, c) VALUES (1, 3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2, 3})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT column_name, extra_info FROM delta.information_schema.columns WHERE table_schema = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", null}), QueryAssert.Row.row((Object[])new Object[]{"b", "generated: a * 2"}), QueryAssert.Row.row((Object[])new Object[]{"c", null})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 3})).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", ""}), QueryAssert.Row.row((Object[])new Object[]{"b", "generated: a * 2"}), QueryAssert.Row.row((Object[])new Object[]{"c", ""})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 3})).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", ""}), QueryAssert.Row.row((Object[])new Object[]{"b", "generated: a * 2"}), QueryAssert.Row.row((Object[])new Object[]{"c", ""})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-73", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testIdentityColumn() {
        String tableName = "test_identity_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (a INT, b BIGINT GENERATED ALWAYS AS IDENTITY)\nUSING DELTA LOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            String failureMessage = ".* Table .* requires Delta Lake writer version 6 which is not supported";
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".b IS 'test column comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(failureMessage);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(failureMessage);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN c INT", new QueryExecutor.QueryParam[0])).hasMessageMatching(failureMessage);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + "(a) VALUES (0)", new QueryExecutor.QueryParam[0])).hasMessageMatching(failureMessage);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(failureMessage);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.a = s.a) WHEN MATCHED THEN UPDATE SET b = 1", new QueryExecutor.QueryParam[0])).hasMessageMatching(failureMessage);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"b BIGINT GENERATED ALWAYS AS IDENTITY"});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (a) VALUES (0)", new QueryExecutor.QueryParam[0]);
            DatabricksVersion databricksRuntimeVersion = DeltaLakeTestUtils.getDatabricksRuntimeVersion().orElseThrow();
            QueryAssert.Row expected = databricksRuntimeVersion.isOlderThan(DatabricksVersion.DATABRICKS_122_RUNTIME_VERSION) ? QueryAssert.Row.row((Object[])new Object[]{0, 1}) : QueryAssert.Row.row((Object[])new Object[]{0, 2});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{expected});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{expected});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

