/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.S3ClientFactory;
import io.trino.tests.product.deltalake.TransactionLogAssertions;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksCreateTableAsSelectCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Inject
    @Named(value="s3.server_type")
    private String s3ServerType;
    private AmazonS3 s3;

    @BeforeTestWithContext
    public void setup() {
        super.setUp();
        this.s3 = new S3ClientFactory().createS3Client(this.s3ServerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testPrestoTypesWithDatabricks() {
        String tableName = "test_dl_ctas_" + TestingNames.randomNameSuffix();
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (id, boolean, tinyint, smallint, integer, bigint, real, double, short_decimal, long_decimal, varchar_25, varchar, date) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "') AS VALUES (1, BOOLEAN 'false', TINYINT '-128', SMALLINT '-32768', INTEGER '-2147483648', BIGINT '-9223372036854775808', REAL '-0x1.fffffeP+127f', DOUBLE '-0x1.fffffffffffffP+1023', CAST('-123456789.123456789' AS DECIMAL(18,9)), CAST('-12345678901234567890.123456789012345678' AS DECIMAL(38,18)), CAST('Romania' AS VARCHAR(25)), CAST('Poland' AS VARCHAR), DATE '1901-01-01'), (2, BOOLEAN 'true', TINYINT '127', SMALLINT '32767', INTEGER '2147483647', BIGINT '9223372036854775807', REAL '0x1.fffffeP+127f', DOUBLE '0x1.fffffffffffffP+1023', CAST('123456789.123456789' AS DECIMAL(18,9)), CAST('12345678901234567890.123456789012345678' AS DECIMAL(38,18)), CAST('Canada' AS VARCHAR(25)), CAST('Germany' AS VARCHAR), DATE '9999-12-31'), (3, BOOLEAN 'true', TINYINT '0', SMALLINT '0', INTEGER '0', BIGINT '0', REAL '0', DOUBLE '0', CAST('0' AS DECIMAL(18,9)), CAST('0' AS DECIMAL(38,18)), CAST('' AS VARCHAR(25)), CAST('' AS VARCHAR), DATE '2020-08-22'), (4, BOOLEAN 'true', TINYINT '1', SMALLINT '1', INTEGER '1', BIGINT '1', REAL '1', DOUBLE '1', CAST('1' AS DECIMAL(18,9)), CAST('1' AS DECIMAL(38,18)), CAST('Romania' AS VARCHAR(25)), CAST('Poland' AS VARCHAR), DATE '2001-08-22'), (5, BOOLEAN 'true', TINYINT '37', SMALLINT '12242', INTEGER '2524', BIGINT '132', REAL '3.141592653', DOUBLE '2.718281828459045', CAST('3.141592653' AS DECIMAL(18,9)), CAST('2.718281828459045' AS DECIMAL(38,18)), CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS VARCHAR(25)), CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS VARCHAR), DATE '2020-08-22'), (6, BOOLEAN 'true', TINYINT '0', SMALLINT '0', INTEGER '0', BIGINT '0', REAL '0x0.000002P-126f', DOUBLE '0x0.0000000000001P-1022', CAST('0' AS DECIMAL(18,9)), CAST('0' AS DECIMAL(38,18)), CAST('Romania' AS VARCHAR(25)), CAST('Poland' AS VARCHAR), DATE '2001-08-22'), (7, BOOLEAN 'true', TINYINT '0', SMALLINT '0', INTEGER '0', BIGINT '0', REAL '0x1.0p-126f', DOUBLE '0x1.0p-1022', CAST('0' AS DECIMAL(18,9)), CAST('0' AS DECIMAL(38,18)), CAST('Romania' AS VARCHAR(25)), CAST('Poland' AS VARCHAR), DATE '2001-08-22')", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{7})});
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsOnly((List)prestoResult.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testPrestoTimestampsWithDatabricks() {
        String tableName = "test_dl_ctas_timestamps_" + TestingNames.randomNameSuffix();
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (id, timestamp_in_utc, timestamp_in_new_york, timestamp_in_warsaw) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "') AS VALUES (1, TIMESTAMP '1901-01-01 00:00:00 UTC', TIMESTAMP '1902-01-01 00:00:00 America/New_York', TIMESTAMP '1902-01-01 00:00:00 Europe/Warsaw'), (2, TIMESTAMP '9999-12-31 23:59:59.999 UTC', TIMESTAMP '9998-12-31 23:59:59.999 America/New_York', TIMESTAMP '9998-12-31 23:59:59.999 Europe/Warsaw'), (3, TIMESTAMP '2020-06-10 15:55:23 UTC', TIMESTAMP '2020-06-10 15:55:23.123 America/New_York', TIMESTAMP '2020-06-10 15:55:23.123 Europe/Warsaw'), (4, TIMESTAMP '2001-08-22 03:04:05.321 UTC', TIMESTAMP '2001-08-22 03:04:05.321 America/New_York', TIMESTAMP '2001-08-22 03:04:05.321 Europe/Warsaw')", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{4})});
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery("SELECT id, date_format(timestamp_in_utc, \"yyyy-MM-dd HH:mm:ss.SSS\"), date_format(timestamp_in_new_york, \"yyyy-MM-dd HH:mm:ss.SSS\"), date_format(timestamp_in_warsaw, \"yyyy-MM-dd HH:mm:ss.SSS\") FROM default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult prestoResult = QueryExecutors.onTrino().executeQuery("SELECT id, format('%1$tF %1$tT.%1$tL', timestamp_in_utc), format('%1$tF %1$tT.%1$tL', timestamp_in_new_york), format('%1$tF %1$tT.%1$tL', timestamp_in_warsaw) FROM delta.default.\"" + tableName + "\"", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsOnly((List)prestoResult.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testPrestoCacheInvalidatedOnCreateTable() throws URISyntaxException, IOException {
        String tableName = "test_dl_ctas_caching_" + TestingNames.randomNameSuffix();
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (id, boolean, tinyint) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "') AS VALUES (1, BOOLEAN 'false', TINYINT '-128'), (2, BOOLEAN 'true', TINYINT '127'), (3, BOOLEAN 'false', TINYINT '0'), (4, BOOLEAN 'false', TINYINT '1'), (5, BOOLEAN 'true', TINYINT '37')", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsOnly((List)prestoResult.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
            DeltaLakeTestUtils.removeS3Directory(this.s3, this.bucketName, "databricks-compatibility-test-" + tableName);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (id, boolean, tinyint) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "') AS VALUES (1, BOOLEAN 'true', TINYINT '1'), (2, BOOLEAN 'true', TINYINT '1'), (3, BOOLEAN 'false', TINYINT '2'), (4, BOOLEAN 'true', TINYINT '3'), (5, BOOLEAN 'true', TINYINT '5'), (6, BOOLEAN 'false', TINYINT '8'), (7, BOOLEAN 'true', TINYINT '13')", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{7})});
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsOnly((List)prestoResult.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCreateFromTrinoWithDefaultPartitionValues() {
        String tableName = "test_create_partitioned_table_default_as_" + TestingNames.randomNameSuffix();
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(number_partition, string_partition, a_value) WITH (   location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "',    partitioned_by = ARRAY['number_partition', 'string_partition']) AS VALUES (NULL, 'partition_a', 'jarmuz'), (1, NULL, 'brukselka'), (NULL, NULL, 'kalafior')", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{null, "partition_a", "jarmuz"}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, null, "brukselka"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, "kalafior"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testReplaceTableWithSchemaChange() {
        String tableName = "test_replace_table_with_schema_change_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " (ts VARCHAR) with (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', checkpoint_interval = 10)", new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList.Builder expected = ImmutableList.builder();
            for (int i = 0; i < 12; ++i) {
                QueryExecutors.onDelta().executeQuery("INSERT INTO " + tableName + " VALUES \"1960-01-01 01:02:03\", \"1961-01-01 01:02:03\", \"1962-01-01 01:02:03\"", new QueryExecutor.QueryParam[0]);
                expected.add((Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1960-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1961-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1962-01-01T01:02:03.000Z"})});
            }
            TransactionLogAssertions.assertTransactionLogVersion(this.s3, this.bucketName, tableName, 12);
            QueryExecutors.onDelta().executeQuery("CREATE OR REPLACE TABLE " + tableName + " USING DELTA AS SELECT CAST(ts AS TIMESTAMP) FROM " + tableName, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT to_iso8601(ts) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected.build());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-113", "delta-lake-exclude-122", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testReplaceTableWithSchemaChangeOnCheckpoint() {
        String tableName = "test_replace_table_with_schema_change_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " (ts VARCHAR) with (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', checkpoint_interval = 10)", new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList.Builder expected = ImmutableList.builder();
            for (int i = 0; i < 9; ++i) {
                QueryExecutors.onDelta().executeQuery("INSERT INTO " + tableName + " VALUES \"1960-01-01 01:02:03\", \"1961-01-01 01:02:03\", \"1962-01-01 01:02:03\"", new QueryExecutor.QueryParam[0]);
                expected.add((Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1960-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1961-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1962-01-01T01:02:03.000Z"})});
            }
            QueryExecutors.onDelta().executeQuery("CREATE OR REPLACE TABLE " + tableName + " USING DELTA AS SELECT CAST(ts AS TIMESTAMP) FROM " + tableName, new QueryExecutor.QueryParam[0]);
            TransactionLogAssertions.assertLastEntryIsCheckpointed(this.s3, this.bucketName, tableName);
            QueryExecutors.onDelta().executeQuery("INSERT INTO " + tableName + " VALUES \"1960-01-01 01:02:03\", \"1961-01-01 01:02:03\", \"1962-01-01 01:02:03\"", new QueryExecutor.QueryParam[0]);
            expected.add((Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1960-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1961-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1962-01-01T01:02:03.000Z"})});
            TransactionLogAssertions.assertTransactionLogVersion(this.s3, this.bucketName, tableName, 11);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT to_iso8601(ts) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected.build());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }
}

