/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hudi;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHudiSparkCompatibility
extends ProductTest {
    private static final String COW_TABLE_TYPE = "cow";
    private static final String MOR_TABLE_TYPE = "mor";
    private String bucketName;

    @BeforeTestWithContext
    public void setUp() {
        this.bucketName = Objects.requireNonNull(System.getenv("S3_BUCKET"), "Environment variable not set: S3_BUCKET");
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testCopyOnWriteShowCreateTable() {
        String tableName = "test_hudi_cow_show_create_" + TestingNames.randomNameSuffix();
        this.createNonPartitionedTable(tableName, COW_TABLE_TYPE);
        try {
            Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE hudi.default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).isEqualTo(String.format("CREATE TABLE hudi.default.%s (\n   _hoodie_commit_time varchar,\n   _hoodie_commit_seqno varchar,\n   _hoodie_record_key varchar,\n   _hoodie_partition_path varchar,\n   _hoodie_file_name varchar,\n   id bigint,\n   name varchar,\n   price integer,\n   ts bigint\n)\nWITH (\n   location = 's3://%s/%s'\n)", tableName, this.bucketName, tableName));
            String lastCommitTimeSync = (String)QueryExecutors.onHudi().executeQuery("show TBLPROPERTIES " + tableName + " ('last_commit_time_sync')", new QueryExecutor.QueryParam[0]).project(new int[]{2}).getOnlyValue();
            Assertions.assertThat((String)((String)QueryExecutors.onHudi().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).isEqualTo(String.format("CREATE TABLE default.%s (\n  _hoodie_commit_time STRING,\n  _hoodie_commit_seqno STRING,\n  _hoodie_record_key STRING,\n  _hoodie_partition_path STRING,\n  _hoodie_file_name STRING,\n  id BIGINT,\n  name STRING,\n  price INT,\n  ts BIGINT)\nUSING hudi\nLOCATION 's3://%s/%s'\nTBLPROPERTIES (\n  'last_commit_time_sync' = '%s',\n  'preCombineField' = 'ts',\n  'primaryKey' = 'id',\n  'type' = 'cow')\n", tableName, this.bucketName, tableName, lastCommitTimeSync));
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testCopyOnWriteTableSelect() {
        String tableName = "test_hudi_cow_select_" + TestingNames.randomNameSuffix();
        this.createNonPartitionedTable(tableName, COW_TABLE_TYPE);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2"}));
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testCopyOnWritePartitionedTableSelect() {
        String tableName = "test_hudi_cow_partitioned_select_" + TestingNames.randomNameSuffix();
        this.createPartitionedTable(tableName, COW_TABLE_TYPE);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1", 1000, "2021-12-09", "10"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 1000, "2021-12-09", "11"}));
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name, ts, dt, hh FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, ts, dt, hh FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 1000}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, ts FROM hudi.default." + tableName + " WHERE dt = '2021-12-09' AND hh = '11'", new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testCopyOnWriteTableSelectAfterUpdate() {
        String tableName = "test_hudi_cow_select_after_update" + TestingNames.randomNameSuffix();
        this.createPartitionedTable(tableName, COW_TABLE_TYPE);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2"}));
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryExecutors.onHudi().executeQuery("UPDATE default." + tableName + " SET name = 'a1_1', ts = 1001 WHERE id = 1", new QueryExecutor.QueryParam[0]);
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1_1", 1001}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 1000}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name, ts FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, ts FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testMergeOnReadTableSelect() {
        String tableName = "test_hudi_mor_select_" + TestingNames.randomNameSuffix();
        this.createNonPartitionedTable(tableName, MOR_TABLE_TYPE);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1", 20, 1000}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 40, 2000}));
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name, price, ts FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, price, ts FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"hudi", "profile_specific_tests"})
    public void testMergeOnReadTableSelectAfterUpdate() {
        String tableName = "test_hudi_mor_update" + TestingNames.randomNameSuffix();
        this.createNonPartitionedTable(tableName, MOR_TABLE_TYPE);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1", 20, 1000}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 40, 2000}));
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name, price, ts FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, price, ts FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryExecutors.onHudi().executeQuery("UPDATE default." + tableName + " SET ts = 2020 WHERE id = 2", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRowsAfterUpdate = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1", 20, 1000}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 40, 2020}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name, price, ts FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRowsAfterUpdate);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, price, ts FROM hudi.default." + tableName + "_ro", new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testMergeOnReadPartitionedTableSelect() {
        String tableName = "test_hudi_mor_partitioned_select_" + TestingNames.randomNameSuffix();
        this.createPartitionedTable(tableName, MOR_TABLE_TYPE);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1", 1000, "2021-12-09", "10"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 1000, "2021-12-09", "11"}));
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHudi().executeQuery("SELECT id, name, ts, dt, hh FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, ts, dt, hh FROM hudi.default." + tableName + "_ro", new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 1000}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name, ts FROM hudi.default." + tableName + "_ro WHERE dt = '2021-12-09' AND hh = '11'", new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testCopyOnWriteTableSelectWithSessionProperties() {
        String tableName = "test_hudi_cow_select_session_props" + TestingNames.randomNameSuffix();
        this.createNonPartitionedTable(tableName, COW_TABLE_TYPE);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT id, name FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2"})));
            QueryExecutors.onTrino().executeQuery("SET SESSION hudi.columns_to_hide = ARRAY['_hoodie_commit_time','_hoodie_commit_seqno','_hoodie_record_key','_hoodie_partition_path','_hoodie_file_name']", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a1", 20, 1000}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a2", 40, 2000})));
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testTimelineTable() {
        String tableName = "test_hudi_timeline_system_table_" + TestingNames.randomNameSuffix();
        this.createNonPartitionedTable(tableName, COW_TABLE_TYPE);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT action, state FROM hudi.default.\"%s$timeline\"", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"commit", "COMPLETED"})});
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testTimelineTableRedirect() {
        String tableName = "test_hudi_timeline_system_table_redirect_" + TestingNames.randomNameSuffix();
        String nonExistingTableName = tableName + "_non_existing";
        this.createNonPartitionedTable(tableName, COW_TABLE_TYPE);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT action, state FROM hive.default.\"%s$timeline\"", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"commit", "COMPLETED"})});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s$timeline\"", nonExistingTableName), new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'hive.default.test_hudi_timeline_system_table_redirect_.*_non_existing\\$timeline' does not exist");
        }
        finally {
            QueryExecutors.onHudi().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private void createNonPartitionedTable(String tableName, String tableType) {
        QueryExecutors.onHudi().executeQuery(String.format("CREATE TABLE default.%s (\n  id bigint,\n  name string,\n  price int,\n  ts bigint)\nUSING hudi\nTBLPROPERTIES (\n  type = '%s',\n  primaryKey = 'id',\n  preCombineField = 'ts')\nLOCATION 's3://%s/%s'", tableName, tableType, this.bucketName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'a1', 20, 1000), (2, 'a2', 40, 2000)", new QueryExecutor.QueryParam[0]);
    }

    private void createPartitionedTable(String tableName, String tableType) {
        QueryExecutors.onHudi().executeQuery(String.format("CREATE TABLE default.%s (\n  id bigint,\n  name string,\n  ts bigint,\n  dt string,\n  hh string)\nUSING hudi\nTBLPROPERTIES (\n  type = '%s',\n  primaryKey = 'id',\n  preCombineField = 'ts')\nPARTITIONED BY (dt, hh)\nLOCATION 's3://%s/%s'", tableName, tableType, this.bucketName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("INSERT INTO default." + tableName + " PARTITION (dt, hh) SELECT 1 AS id, 'a1' AS name, 1000 AS ts, '2021-12-09' AS dt, '10' AS hh", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("INSERT INTO default." + tableName + " PARTITION (dt = '2021-12-09', hh='11') SELECT 2, 'a2', 1000", new QueryExecutor.QueryParam[0]);
    }
}

