/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class TestAlterTable
extends ProductTest {
    private static final String TABLE_NAME = "table_name";
    private static final String RENAMED_TABLE_NAME = "renamed_table_name";

    @BeforeMethodWithContext
    @AfterMethodWithContext
    public void dropTestTables() {
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", RENAMED_TABLE_NAME), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"alter_table", "smoke"})
    public void renameTable() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM nation", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s RENAME TO %s", TABLE_NAME, RENAMED_TABLE_NAME), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", RENAMED_TABLE_NAME), new QueryExecutor.QueryParam[0]))).hasRowsCount(25);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s RENAME TO %s", RENAMED_TABLE_NAME, TABLE_NAME), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
    }

    @Test(groups={"alter_table", "smoke"})
    public void renameColumn() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM nation", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN n_nationkey TO nationkey", TABLE_NAME), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(nationkey) FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN nationkey TO nATIoNkEy", TABLE_NAME), new QueryExecutor.QueryParam[0])).hasMessageContaining("Column 'nationkey' already exists");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN nationkey TO n_regionkeY", TABLE_NAME), new QueryExecutor.QueryParam[0])).hasMessageContaining("Column 'n_regionkey' already exists");
        QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN nationkey TO n_nationkey", TABLE_NAME), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"alter_table", "smoke"})
    public void addColumn() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM nation", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(1) FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s ADD COLUMN some_new_column BIGINT", TABLE_NAME), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s ADD COLUMN n_nationkey BIGINT", TABLE_NAME), new QueryExecutor.QueryParam[0])).hasMessageContaining("Column 'n_nationkey' already exists");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s ADD COLUMN n_naTioNkEy BIGINT", TABLE_NAME), new QueryExecutor.QueryParam[0])).hasMessageContaining("Column 'n_naTioNkEy' already exists");
    }

    @Test(groups={"alter_table", "smoke"})
    public void dropColumn() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s AS SELECT n_nationkey, n_regionkey, n_name FROM nation", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(n_nationkey) FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s DROP COLUMN n_name", TABLE_NAME), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s DROP COLUMN n_nationkey", TABLE_NAME), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE %s DROP COLUMN n_regionkey", TABLE_NAME), new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot drop the only column in a table");
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
    }
}

