/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.net.URI;
import java.net.URISyntaxException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestImpersonation
extends ProductTest {
    private QueryExecutor aliceExecutor;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.alice@presto.jdbc_user")
    private String aliceJdbcUser;
    @Inject
    @Named(value="databases.presto.configured_hdfs_user")
    private String configuredHdfsUser;

    @BeforeMethodWithContext
    public void setup() {
        this.aliceExecutor = QueryExecutors.connectToTrino("alice@presto");
    }

    @AfterMethodWithContext
    public void cleanup() {
        this.aliceExecutor = null;
    }

    @Test(groups={"hdfs_no_impersonation", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testHdfsImpersonationDisabled() {
        String tableName = "check_hdfs_impersonation_disabled";
        this.checkTableOwner(tableName, this.configuredHdfsUser, this.aliceExecutor);
    }

    @Test(groups={"hdfs_impersonation", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testHdfsImpersonationEnabled() {
        String tableName = "check_hdfs_impersonation_enabled";
        this.checkTableOwner(tableName, this.aliceJdbcUser, this.aliceExecutor);
        this.checkTableGroup(tableName, this.aliceExecutor);
    }

    private static String getTableLocation(QueryExecutor executor, String tableName) {
        String location = (String)Iterables.getOnlyElement((Iterable)executor.executeQuery(String.format("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM %s", tableName), new QueryExecutor.QueryParam[0]).column(1));
        if (location.startsWith("hdfs://")) {
            try {
                URI uri = new URI(location);
                return uri.getPath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return location;
    }

    private void checkTableOwner(String tableName, String expectedOwner, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT 'abc' c", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = TestImpersonation.getTableLocation(executor, tableName);
        String owner = this.hdfsClient.getOwner(tableLocation);
        Assert.assertEquals((String)owner, (String)expectedOwner);
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    private void checkTableGroup(String tableName, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT 'abc' c", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = TestImpersonation.getTableLocation(executor, tableName);
        String warehouseLocation = tableLocation.substring(0, tableLocation.lastIndexOf("/"));
        String warehouseLocationGroup = this.hdfsClient.getGroup(warehouseLocation);
        String tableLocationGroup = this.hdfsClient.getGroup(warehouseLocation);
        Assert.assertEquals((String)tableLocationGroup, (String)warehouseLocationGroup);
    }
}

